/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Ignore;
import org.junit.Test;

public class RuleSheetParserUtilTest {
    @Test
    public void testRuleName() {
        String row = "  RuleTable       This is my rule name";
        String result = RuleSheetParserUtil.getRuleName((String)"  RuleTable       This is my rule name");
        Assertions.assertThat((String)result).isEqualTo("This is my rule name");
    }

    @Ignore
    @Test
    public void testInvalidRuleName() {
        String row = "RuleTable       This is my rule name (type class)";
        try {
            String result = RuleSheetParserUtil.getRuleName((String)"RuleTable       This is my rule name (type class)");
            Assertions.fail((String)("should have failed, but get result: " + result));
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).isNotNull();
        }
    }

    @Test
    public void testIsStringMeaningTrue() {
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"true")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"TRUE")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"yes")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"oN")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"no")).isFalse();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"false")).isFalse();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue(null)).isFalse();
    }

    @Test
    public void testListImports() {
        ArrayList<String> cellVals = null;
        List list = RuleSheetParserUtil.getImportList(cellVals);
        Assertions.assertThat((List)list).isNotNull();
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        cellVals = new ArrayList<String>();
        cellVals.add("");
        Assertions.assertThat((int)RuleSheetParserUtil.getImportList(cellVals).size()).isEqualTo(0);
        cellVals.add(0, "com.something.Yeah, com.something.No,com.something.yeah.*");
        list = RuleSheetParserUtil.getImportList(cellVals);
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat((String)((Import)list.get(0)).getClassName()).isEqualTo("com.something.Yeah");
        Assertions.assertThat((String)((Import)list.get(1)).getClassName()).isEqualTo("com.something.No");
        Assertions.assertThat((String)((Import)list.get(2)).getClassName()).isEqualTo("com.something.yeah.*");
    }

    @Test
    public void testListVariables() {
        ArrayList<String> varCells = new ArrayList<String>();
        varCells.add("Var1 var1, Var2 var2,Var3 var3");
        List varList = RuleSheetParserUtil.getVariableList(varCells);
        Assertions.assertThat((List)varList).isNotNull();
        Assertions.assertThat((int)varList.size()).isEqualTo(3);
        Global var = (Global)varList.get(0);
        Assertions.assertThat((String)var.getClassName()).isEqualTo("Var1");
        var = (Global)varList.get(2);
        Assertions.assertThat((String)var.getClassName()).isEqualTo("Var3");
        Assertions.assertThat((String)var.getIdentifier()).isEqualTo("var3");
    }

    @Test
    public void testBadVariableFormat() {
        ArrayList<String> varCells = new ArrayList<String>();
        varCells.add("class1, object2");
        try {
            RuleSheetParserUtil.getVariableList(varCells);
            Assertions.fail((String)"should not work");
        }
        catch (DecisionTableParseException e) {
            Assertions.assertThat((String)e.getMessage()).isNotNull();
        }
    }

    @Test
    public void testRowColumnToCellNAme() {
        String cellName = RuleSheetParserUtil.rc2name((int)0, (int)0);
        Assertions.assertThat((String)cellName).isEqualTo("A1");
        cellName = RuleSheetParserUtil.rc2name((int)0, (int)10);
        Assertions.assertThat((String)cellName).isEqualTo("K1");
        cellName = RuleSheetParserUtil.rc2name((int)0, (int)42);
        Assertions.assertThat((String)cellName).isEqualTo("AQ1");
        cellName = RuleSheetParserUtil.rc2name((int)9, (int)27);
        Assertions.assertThat((String)cellName).isEqualTo("AB10");
        cellName = RuleSheetParserUtil.rc2name((int)99, (int)53);
        Assertions.assertThat((String)cellName).isEqualTo("BB100");
    }
}

