/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import com.sample.FactData;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.Person;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.After;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class LineBreakXLSTest {
    private KieSession ksession;

    @After
    public void tearDown() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void makeSureAdditionalCodeLineEndsAreNotAdded() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLSX);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"testrule.drl.xlsx", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = kbase.newKieSession();
        FactData fd = new FactData();
        fd.set\u5024(-1);
        this.ksession.insert((Object)fd);
        this.ksession.fireAllRules();
        Assertions.assertThat((String)fd.get\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8()).contains(new CharSequence[]{"\u5024\u306b\u306f0\u4ee5\u4e0a\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u6307\u5b9a\u3055\u308c\u305f\u5024\uff1a"});
    }

    @Test
    public void testMultipleLinesInAction() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"MultiLinesInAction.drl.xls", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = kbase.newKieSession();
        Person john = new Person("John");
        john.setAge(20);
        john.setAlive(true);
        this.ksession.insert((Object)john);
        this.ksession.fireAllRules();
        Assertions.assertThat((int)john.getAge()).isEqualTo(30);
        Assertions.assertThat((boolean)john.isAlive()).isFalse();
    }

    @Test
    public void testMultipleLinesInCells() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"MultiLinesInCells.drl.xls", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assertions.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = kbase.newKieSession();
        Person john = new Person("John");
        john.setAge(20);
        john.setAlive(true);
        this.ksession.insert((Object)john);
        this.ksession.fireAllRules();
        Assertions.assertThat((int)john.getAge()).isEqualTo(30);
        Assertions.assertThat((String)john.getName()).isEqualTo("ssss\nxxxx");
    }
}

