/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.ActionType;
import org.junit.Test;

public class ActionTypeTest {
    @Test
    public void testChooseActionType() {
        this.checkActionType("C", ActionType.Code.CONDITION);
        this.checkActionType("CONDITION", ActionType.Code.CONDITION);
        this.checkActionType("A", ActionType.Code.ACTION);
        this.checkActionType("ACTION", ActionType.Code.ACTION);
        this.checkActionType("N", ActionType.Code.NAME);
        this.checkActionType("NAME", ActionType.Code.NAME);
        this.checkActionType("I", ActionType.Code.DESCRIPTION);
        this.checkActionType("DESCRIPTION", ActionType.Code.DESCRIPTION);
        this.checkActionType("P", ActionType.Code.SALIENCE);
        this.checkActionType("PRIORITY", ActionType.Code.SALIENCE);
        this.checkActionType("D", ActionType.Code.DURATION);
        this.checkActionType("DURATION", ActionType.Code.DURATION);
        this.checkActionType("T", ActionType.Code.TIMER);
        this.checkActionType("TIMER", ActionType.Code.TIMER);
        this.checkActionType("E", ActionType.Code.CALENDARS);
        this.checkActionType("CALENDARS", ActionType.Code.CALENDARS);
        this.checkActionType("U", ActionType.Code.NOLOOP);
        this.checkActionType("NO-LOOP", ActionType.Code.NOLOOP);
        this.checkActionType("L", ActionType.Code.LOCKONACTIVE);
        this.checkActionType("LOCK-ON-ACTIVE", ActionType.Code.LOCKONACTIVE);
        this.checkActionType("F", ActionType.Code.AUTOFOCUS);
        this.checkActionType("AUTO-FOCUS", ActionType.Code.AUTOFOCUS);
        this.checkActionType("X", ActionType.Code.ACTIVATIONGROUP);
        this.checkActionType("ACTIVATION-GROUP", ActionType.Code.ACTIVATIONGROUP);
        this.checkActionType("G", ActionType.Code.AGENDAGROUP);
        this.checkActionType("AGENDA-GROUP", ActionType.Code.AGENDAGROUP);
        this.checkActionType("R", ActionType.Code.RULEFLOWGROUP);
        this.checkActionType("RULEFLOW-GROUP", ActionType.Code.RULEFLOWGROUP);
        this.checkActionType("V", ActionType.Code.DATEEFFECTIVE);
        this.checkActionType("DATE-EFFECTIVE", ActionType.Code.DATEEFFECTIVE);
        this.checkActionType("Z", ActionType.Code.DATEEXPIRES);
        this.checkActionType("DATE-EXPIRES", ActionType.Code.DATEEXPIRES);
        this.checkActionType("@", ActionType.Code.METADATA);
        this.checkActionType("METADATA", ActionType.Code.METADATA);
    }

    private void checkActionType(String value, ActionType.Code code) {
        HashMap actionTypeMap = new HashMap();
        ActionType.addNewActionType(actionTypeMap, (String)value, (int)0, (int)1);
        Assertions.assertThat((Comparable)((ActionType)actionTypeMap.get(0)).getCode()).isEqualTo((Object)code);
    }
}

