/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Ignore;
import org.junit.Test;

public class RuleSheetParserUtilTest {
    @Test
    public void testRuleName() {
        String row = "  RuleTable       This is my rule name";
        String result = RuleSheetParserUtil.getRuleName((String)"  RuleTable       This is my rule name");
        Assertions.assertThat((String)result).isEqualTo("This is my rule name");
    }

    @Ignore
    @Test
    public void testInvalidRuleName() {
        String row = "RuleTable       This is my rule name (type class)";
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> RuleSheetParserUtil.getRuleName((String)"RuleTable       This is my rule name (type class)"));
    }

    @Test
    public void testIsStringMeaningTrue() {
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"true")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"TRUE")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"yes")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"oN")).isTrue();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"no")).isFalse();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"false")).isFalse();
        Assertions.assertThat((boolean)RuleSheetParserUtil.isStringMeaningTrue(null)).isFalse();
    }

    @Test
    public void getImportList_nullValue() {
        ((ListAssert)Assertions.assertThat((List)RuleSheetParserUtil.getImportList(null)).isNotNull()).isEmpty();
    }

    @Test
    public void getImportList_listOfEmptyString() {
        ((ListAssert)Assertions.assertThat((List)RuleSheetParserUtil.getImportList(List.of(""))).isNotNull()).isEmpty();
    }

    @Test
    public void getImportList_maniValues() {
        List list = RuleSheetParserUtil.getImportList(List.of("", "com.something.Yeah, com.something.No,com.something.yeah.*"));
        ((ListAssert)Assertions.assertThat((List)list).hasSize(3)).extracting(x -> x.getClassName()).containsExactly((Object[])new String[]{"com.something.Yeah", "com.something.No", "com.something.yeah.*"});
    }

    @Test
    public void testListVariables() {
        List varList = RuleSheetParserUtil.getVariableList(List.of("Var1 var1, Var2 var2,Var3 var3"));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)varList).isNotNull()).hasSize(3)).extracting(x -> x.getClassName()).containsExactly((Object[])new String[]{"Var1", "Var2", "Var3"});
    }

    @Test
    public void testBadVariableFormat() {
        List<String> varCells = List.of("class1, object2");
        Assertions.assertThatExceptionOfType(DecisionTableParseException.class).isThrownBy(() -> RuleSheetParserUtil.getVariableList((List)varCells));
    }

    @Test
    public void testRowColumnToCellNAme() {
        Assertions.assertThat((String)RuleSheetParserUtil.rc2name((int)0, (int)0)).isEqualTo("A1");
        Assertions.assertThat((String)RuleSheetParserUtil.rc2name((int)0, (int)10)).isEqualTo("K1");
        Assertions.assertThat((String)RuleSheetParserUtil.rc2name((int)0, (int)42)).isEqualTo("AQ1");
        Assertions.assertThat((String)RuleSheetParserUtil.rc2name((int)9, (int)27)).isEqualTo("AB10");
        Assertions.assertThat((String)RuleSheetParserUtil.rc2name((int)99, (int)53)).isEqualTo("BB100");
    }
}

