/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Package;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Test;

public class RuleWorksheetParse2Test {
    private RuleSheetListener listener;
    private int row;

    @Test
    public void tooManyColumnsNoLoop() {
        this.makeRuleSet();
        this.makeRuleTable();
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(11, "C", "C", "A", "U", "U")).withMessageContaining(RuleSheetParserUtil.rc2name((int)11, (int)5));
    }

    @Test
    public void tooManyColumnsPriority() {
        this.makeRuleSet();
        this.makeRuleTable();
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(11, "C", "C", "A", "PRIORITY", "P")).withMessageContaining(RuleSheetParserUtil.rc2name((int)11, (int)5));
    }

    @Test
    public void columnsHeadersMustBeValid() {
        this.makeRuleSet();
        this.makeRuleTable();
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(11, "Condition", "CONDITION", "A", "SMURF", "P")).withMessageContaining(RuleSheetParserUtil.rc2name((int)11, (int)4));
    }

    @Test
    public void mustHaveATypeForAPatternBelowACondition() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "C", "C", "A", "A");
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(12, "attr == $param", "attr == $param", "attr == $param", "action();", "action();")).withMessageContaining(RuleSheetParserUtil.rc2name((int)12, (int)1));
    }

    @Test
    public void spuriousCodeSnippet() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "C", "A");
        this.makeRow(12, "Foo", "Foo");
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(13, "attr == $param", "attr == $param", "action();", "attr > $param")).withMessageContaining(RuleSheetParserUtil.rc2name((int)13, (int)4));
    }

    @Test
    public void incorrectNonNumericPriority() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "P");
        this.makeRow(12, "Foo", "Foo");
        this.makeRow(13, "attr == $param", "x");
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(15, "1", "show()", "12E")).withMessageContaining(RuleSheetParserUtil.rc2name((int)15, (int)3));
    }

    @Test
    public void mustNotHaveSnippetForAttribute() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "G");
        this.makeRow(12, "Foo", "Foo");
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(13, "attr == $param", "x", "XXX")).withMessageContaining(RuleSheetParserUtil.rc2name((int)13, (int)3));
    }

    @Test
    public void testRuleAttributeRendering() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "G");
        this.makeRow(12, "Foo", "Foo");
        this.makeRow(13, "attr == $param", "x");
        this.makeRow(15, "1", "show()", "foo bar");
        this.makeRow(16, "2", "list()", "\"10\" group\"");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"agenda-group \"foo bar\"", "agenda-group \"10\\\" group\""});
    }

    @Test
    public void packageLevelAttributesShouldNotBeDuplicated() {
        this.makeRuleSet();
        this.makeAttribute("agenda-group", "agroup");
        this.makeAttribute("agenda-group", "bgroup");
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "P");
        this.makeRow(12, "Foo", "Foo");
        this.makeRow(13, "attr == $param", "x");
        this.makeRow(15, "1", "show()", "10");
        this.listener.finishSheet();
        Assertions.assertThatException().isThrownBy(() -> this.listener.getRuleSet()).withMessageContaining("C3, C4");
    }

    @Test
    public void packageAttributesAreRenderedCorrectly() {
        this.makeRuleSet();
        this.makeAttribute("NO-LOOP", "true");
        this.makeAttribute("agenda-group", "agroup");
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "P");
        this.makeRow(12, "foo:Foo", "foo");
        this.makeRow(13, "attr == $param", "x($param)");
        this.makeRow(15, "1", "1", "100");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"no-loop true", "agenda-group \"agroup\""});
    }

    @Test
    public void missingCodeSnippetInAction() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A");
        this.makeRow(12, "foo: Foo", "Bar()");
        this.makeRow(13, "attr == $param");
        Assertions.assertThatException().isThrownBy(() -> this.makeRow(15, "1", "1")).withMessageContaining(RuleSheetParserUtil.rc2name((int)13, (int)2));
    }

    @Test
    public void metadataIsCorrect() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "@", "@");
        this.makeRow(12, "foo: Foo", "foo");
        this.makeRow(13, "attr == $param", "goaway($param)", "Author($param)", "Version($1-$2)");
        this.makeRow(15, "1", "1", "J.W.Goethe", "3,14");
        this.makeRow(16, "2", "2", "", "");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"@Author(J.W.Goethe)", "@Version(3-14)"});
        Assertions.assertThat((String)drl).doesNotContain(new CharSequence[]{"@Author()", "@Version(-)"});
    }

    private void makeRuleSet() {
        this.listener = new DefaultRuleSheetListener();
        this.listener.startSheet("bad_sheet");
        this.row = 1;
        this.listener.newRow(this.row, 2);
        this.listener.newCell(this.row, 1, "RuleSet", -1);
        this.listener.newCell(this.row, 2, "myRuleSet", -1);
    }

    private void makeAttribute(String key, String val) {
        ++this.row;
        this.listener.newRow(this.row, 2);
        this.listener.newCell(this.row, 1, key, -1);
        this.listener.newCell(this.row, 2, val, -1);
    }

    private void makeRuleTable() {
        this.listener.newRow(10, 1);
        this.listener.newCell(10, 1, "RuleTable myRuleTable", -1);
    }

    private void makeRow(int row, String ... values) throws DecisionTableParseException {
        this.listener.newRow(row, values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            this.listener.newCell(row, i + 1, values[i], -1);
        }
    }
}

