/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.decisiontable.parser.csv.CsvLineParser;
import org.junit.Test;

public class CsvLineParserTest {
    @Test
    public void testSimpleLineParse() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,b,c";
        List list = parser.parse((CharSequence)"a,b,c");
        ((ListAssert)Assertions.assertThat((List)list).hasSize(3)).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void testLineParse() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,\"b\",c";
        List list = parser.parse((CharSequence)"a,\"b\",c");
        ((ListAssert)Assertions.assertThat((List)list).hasSize(3)).containsExactly((Object[])new String[]{"a", "b", "c"});
    }

    @Test
    public void testDoubleQuotes() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,\"\"\"b\"\"\",c";
        List list = parser.parse((CharSequence)"a,\"\"\"b\"\"\",c");
        ((ListAssert)Assertions.assertThat((List)list).hasSize(3)).containsExactly((Object[])new String[]{"a", "\"b\"", "c"});
    }
}

