/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.csv.CsvLineParser;
import org.drools.decisiontable.parser.csv.CsvParser;
import org.drools.template.parser.DataListener;
import org.junit.Test;

public class CsvParserTest {
    @Test
    public void testCsv() {
        MockSheetListener listener = new MockSheetListener();
        CsvLineParser lineParser = new CsvLineParser();
        CsvParser parser = new CsvParser((DataListener)listener, lineParser);
        parser.parseFile(this.getClass().getResourceAsStream("/data/TestCsv.drl.csv"));
        Assertions.assertThat((String)listener.getCell(0, 0)).isEqualTo("A");
        Assertions.assertThat((String)listener.getCell(0, 1)).isEqualTo("B");
        Assertions.assertThat((String)listener.getCell(2, 0)).isEqualTo("");
        Assertions.assertThat((String)listener.getCell(1, 0)).isEqualTo("C");
        Assertions.assertThat((String)listener.getCell(1, 1)).isEqualTo("D");
        Assertions.assertThat((String)listener.getCell(1, 3)).isEqualTo("E");
    }

    @Test
    public void testCellMergeHandling() {
        CsvParser parser = new CsvParser((DataListener)null, null);
        Assertions.assertThat((int)parser.calcStartMerge(-1, 1, "foo")).isEqualTo(-1);
        Assertions.assertThat((int)parser.calcStartMerge(-1, 42, "...")).isEqualTo(42);
        Assertions.assertThat((int)parser.calcStartMerge(42, 43, "...")).isEqualTo(42);
        Assertions.assertThat((int)parser.calcStartMerge(42, 44, "VanHalen")).isEqualTo(-1);
        Assertions.assertThat((String)parser.calcCellText(-1, "VanHalen")).isEqualTo("VanHalen");
        Assertions.assertThat((String)parser.calcCellText(42, "VanHalen...")).isEqualTo("VanHalen");
        Assertions.assertThat((String)parser.calcCellText(42, "...")).isEqualTo("");
    }

    static class MockSheetListener
    implements DataListener {
        Map<String, String> data = new HashMap<String, String>();

        MockSheetListener() {
        }

        public String getCell(int row, int col) {
            return this.data.get(this.cellKey(row, col));
        }

        public void startSheet(String name) {
        }

        public void finishSheet() {
        }

        public void newRow(int rowNumber, int columns) {
        }

        public void newCell(int row, int column, String value, int mergeCellStart) {
            this.data.put(this.cellKey(row, column), value);
        }

        String cellKey(int row, int column) {
            return "R" + row + "C" + column;
        }
    }
}

