/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.state;

import java.io.IOException;
import java.io.InputStreamReader;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.examples.state.State;

public class StateExampleWithDynamicRules {
    public static void main(String[] args) {
        PackageBuilder builder = new PackageBuilder();
        try {
            builder.addPackageFromDrl(new InputStreamReader(StateExampleWithDynamicRules.class.getResourceAsStream("StateExampleUsingSalience.drl")));
        }
        catch (DroolsParserException e) {
            throw new IllegalArgumentException("Invalid drl", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read drl", e);
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        State a = new State("A");
        State b = new State("B");
        State c = new State("C");
        State d = new State("D");
        State e = new State("E");
        boolean dynamic = true;
        session.insert(a, true);
        session.insert(b, true);
        session.insert(c, true);
        session.insert(d, true);
        session.insert(e, true);
        session.fireAllRules();
        builder = new PackageBuilder();
        try {
            builder.addPackageFromDrl(new InputStreamReader(StateExampleWithDynamicRules.class.getResourceAsStream("StateExampleDynamicRule.drl")));
        }
        catch (DroolsParserException ex) {
            throw new IllegalArgumentException("Invalid drl", ex);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not read drl", ex);
        }
        ruleBase.addPackage(builder.getPackage());
        session.fireAllRules();
        session.dispose();
    }
}

