/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.BaseDescr;
import org.drools.verifier.components.Consequence;
import org.drools.verifier.components.PackageComponent;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.report.components.Cause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierRule
extends PackageComponent
implements Cause {
    private Map<String, String> attributes = new HashMap<String, String>();
    private String consequencePath;
    private Consequence.ConsequenceType consequenceType;
    private int lineNumber;
    private int packageId;
    private String name;
    private Collection<String> header = new ArrayList<String>();
    private Collection<String> lhsRows = new ArrayList<String>();
    private Collection<String> rhsRows = new ArrayList<String>();
    private String description;
    private Map<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
    private Collection<String> commentMetadata = new ArrayList<String>();
    private Map<String, List<String>> otherInfo = new HashMap<String, List<String>>();
    private int offset = 0;

    public VerifierRule(BaseDescr descr, RulePackage rulePackage) {
        super(descr, rulePackage);
    }

    @Override
    public String getPath() {
        return String.format("%s/rule[@name='%s']", this.getPackagePath(), this.getName());
    }

    public int getOffset() {
        ++this.offset;
        return this.offset % 2;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getConsequencePath() {
        return this.consequencePath;
    }

    public void setConsequencePath(String consequencePath) {
        this.consequencePath = consequencePath;
    }

    public Consequence.ConsequenceType getConsequenceType() {
        return this.consequenceType;
    }

    public void setConsequenceType(Consequence.ConsequenceType consequenceType) {
        this.consequenceType = consequenceType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public String toString() {
        return "Rule '" + this.getName() + "'";
    }

    public int getPackageId() {
        return this.packageId;
    }

    public void setPackageId(int packageId) {
        this.packageId = packageId;
    }

    @Override
    public VerifierComponentType getVerifierComponentType() {
        return VerifierComponentType.RULE;
    }

    public Collection<String> getHeader() {
        return this.header;
    }

    public Collection<String> getLhsRows() {
        return this.lhsRows;
    }

    public Collection<String> getRhsRows() {
        return this.rhsRows;
    }

    public Map<String, Map<String, String>> getMetadata() {
        return this.metadata;
    }

    public String getMetaAttribute(String key) {
        Map<String, String> elementValues = this.metadata.get(key);
        return elementValues != null ? elementValues.keySet().iterator().next() : null;
    }

    public Collection<String> getCommentMetadata() {
        return this.commentMetadata;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, List<String>> getOtherInfo() {
        return this.otherInfo;
    }
}

