/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NetworkNode;
import org.drools.common.RuleBasePartitionId;
import org.drools.definition.rule.Rule;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.spi.RuleComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseNode
implements NetworkNode {
    protected int id;
    protected RuleBasePartitionId partitionId;
    protected boolean partitionsEnabled;
    protected Map<Rule, RuleComponent> associations;

    public BaseNode() {
    }

    public BaseNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this.id = id;
        this.partitionId = partitionId;
        this.partitionsEnabled = partitionsEnabled;
        this.associations = new HashMap<Rule, RuleComponent>();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.partitionId = (RuleBasePartitionId)in.readObject();
        this.partitionsEnabled = in.readBoolean();
        this.associations = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.partitionId);
        out.writeBoolean(this.partitionsEnabled);
        out.writeObject(this.associations);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public abstract void attach();

    public abstract void attach(InternalWorkingMemory[] var1);

    public abstract void networkUpdated();

    public void remove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.removeAssociation(context.getRule());
        this.doRemove(context, builder, node, workingMemories);
        if (!this.isInUse() && !(this instanceof EntryPointNode)) {
            builder.getIdGenerator().releaseId(this.getId());
        }
    }

    protected abstract void doRemove(RuleRemovalContext var1, ReteooBuilder var2, BaseNode var3, InternalWorkingMemory[] var4);

    public abstract boolean isInUse();

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ")]";
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public void addAssociation(Rule rule, RuleComponent component) {
        this.associations.put(rule, component);
    }

    public Map<Rule, RuleComponent> getAssociations() {
        return this.associations;
    }

    public void removeAssociation(Rule rule) {
        this.associations.remove(rule);
    }
}

