/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.examples.templates.Cheese;
import org.drools.examples.templates.Person;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ByteArrayResource;
import org.drools.runtime.StatefulKnowledgeSession;

public class SimpleRuleTemplateExample {
    public static void main(String[] args) throws Exception {
        SimpleRuleTemplateExample launcher = new SimpleRuleTemplateExample();
        launcher.executeExample();
    }

    private void executeExample() throws Exception {
        KnowledgeBase kbase = this.buildKBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        System.out.println(list);
        ksession.dispose();
    }

    private KnowledgeBase buildKBase() throws IOException {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile(this.getSpreadsheetStream(), this.getRulesStream(), 2, 2);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println("Error compiling resources:");
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                System.out.println("\t" + ((KnowledgeBuilderError)errors.next()).getMessage());
            }
            throw new IllegalStateException("Error compiling resources");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private InputStream getSpreadsheetStream() throws IOException {
        return ResourceFactory.newClassPathResource((String)"org/drools/examples/ExampleCheese.xls").getInputStream();
    }

    private InputStream getRulesStream() throws IOException {
        return ResourceFactory.newClassPathResource((String)"org/drools/examples/Cheese.drt").getInputStream();
    }
}

