/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.IntervalProviderConstraint;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class EvaluatorConstraint
extends MutableTypeConstraint
implements IntervalProviderConstraint {
    private Declaration[] declarations;
    private Evaluator evaluator;
    private InternalReadAccessor extractor;
    private FieldValue field;

    public EvaluatorConstraint() {
    }

    public EvaluatorConstraint(FieldValue field, Evaluator evaluator, InternalReadAccessor extractor) {
        this.field = field;
        this.declarations = new Declaration[0];
        this.evaluator = evaluator;
        this.extractor = extractor;
    }

    public EvaluatorConstraint(Declaration[] declarations, Evaluator evaluator, InternalReadAccessor extractor) {
        this.declarations = declarations;
        this.evaluator = evaluator;
        this.extractor = extractor;
    }

    private boolean isLiteral() {
        return this.declarations.length == 0;
    }

    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(workingMemory, this.extractor, handle.getObject(), this.field);
        }
        return this.evaluator.evaluate(workingMemory, this.extractor, this.evaluator.prepareLeftObject(handle), this.declarations[0].getExtractor(), this.evaluator.prepareRightObject(handle));
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(((LiteralContextEntry)context).workingMemory, ((LiteralContextEntry)context).getFieldExtractor(), handle.getObject(), this.field);
        }
        return this.evaluator.evaluateCachedLeft(((VariableRestriction.VariableContextEntry)context).workingMemory, (VariableRestriction.VariableContextEntry)context, this.evaluator.prepareRightObject(handle));
    }

    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(((LiteralContextEntry)context).workingMemory, ((LiteralContextEntry)context).getFieldExtractor(), ((LiteralContextEntry)context).getObject(), this.field);
        }
        return this.evaluator.evaluateCachedRight(((VariableRestriction.VariableContextEntry)context).workingMemory, (VariableRestriction.VariableContextEntry)context, this.evaluator.prepareLeftObject(tuple.get(this.declarations[0])));
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.declarations[0].equals(oldDecl)) {
            this.declarations[0] = newDecl;
        }
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public boolean isTemporal() {
        return this.evaluator != null && this.evaluator.isTemporal();
    }

    public Interval getInterval() {
        return this.evaluator == null ? null : this.evaluator.getInterval();
    }

    public Object clone() {
        return this.isLiteral() ? new EvaluatorConstraint(this.field, this.evaluator, this.extractor) : new EvaluatorConstraint(this.declarations, this.evaluator, this.extractor);
    }

    public ContextEntry createContextEntry() {
        return this.isLiteral() ? new LiteralContextEntry(this.extractor) : VariableRestriction.createContextEntry(this.extractor, this.declarations[0], this.evaluator);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.field);
        out.writeObject(this.declarations);
        out.writeObject(this.extractor);
        out.writeObject(this.evaluator);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.field = (FieldValue)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.extractor = (InternalReadAccessor)in.readObject();
        this.evaluator = (Evaluator)in.readObject();
    }

    private static class LiteralContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public InternalReadAccessor extractor;
        public Object object;
        public ContextEntry next;
        public InternalWorkingMemory workingMemory;

        public LiteralContextEntry() {
        }

        public LiteralContextEntry(InternalReadAccessor extractor) {
            this.extractor = extractor;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (InternalReadAccessor)in.readObject();
            this.object = in.readObject();
            this.next = (ContextEntry)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.object);
            out.writeObject(this.next);
            out.writeObject(this.workingMemory);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public Object getObject() {
            return this.object;
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = handle.getObject();
            this.workingMemory = workingMemory;
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
        }

        public void resetTuple() {
        }

        public void resetFactHandle() {
            this.object = null;
        }
    }
}

