/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.util.Map;
import org.drools.rule.constraint.ConditionAnalyzer;
import org.drools.rule.constraint.ConditionEvaluator;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.And;
import org.mvel2.ast.BinaryOperation;
import org.mvel2.ast.BooleanNode;
import org.mvel2.ast.Or;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableAccessor;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.util.ASTLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MvelConditionEvaluator
implements ConditionEvaluator {
    private ExecutableStatement stmt;
    private String expression;
    private ParserContext parserContext;
    private boolean evaluated = false;

    MvelConditionEvaluator(ParserConfiguration conf, String expression) {
        this.expression = expression;
        this.parserContext = new ParserContext(conf);
        this.stmt = (ExecutableStatement)MVEL.compileExpression((String)expression, (ParserContext)this.parserContext);
    }

    @Override
    public boolean evaluate(Object object, Map<String, Object> vars) {
        return this.evaluate(this.stmt, object, vars);
    }

    private boolean evaluate(ExecutableStatement statement, Object object, Map<String, Object> vars) {
        return vars == null ? (Boolean)MVEL.executeExpression((Object)statement, (Object)object) : (Boolean)MVEL.executeExpression((Object)statement, (Object)object, vars);
    }

    ConditionAnalyzer.Condition getAnalyzedCondition() {
        return this.isCompletelyEvaluated() ? new ConditionAnalyzer(this.stmt).analyzeCondition() : null;
    }

    ConditionAnalyzer.Condition getAnalyzedCondition(Object object, Map<String, Object> vars) {
        this.ensureCompleteEvaluation(object, vars);
        return new ConditionAnalyzer(this.stmt, vars).analyzeCondition();
    }

    private void ensureCompleteEvaluation(Object object, Map<String, Object> vars) {
        if (!this.evaluated) {
            this.ensureCompleteEvaluation(this.getRootNode(), object, vars);
            this.evaluated = true;
        }
    }

    private void ensureCompleteEvaluation(ASTNode node, Object object, Map<String, Object> vars) {
        if (!(node instanceof And) && !(node instanceof Or)) {
            return;
        }
        ASTNode rightNode = ((BooleanNode)node).getRight();
        if (!this.isEvaluated(rightNode)) {
            this.evaluate((ExecutableStatement)this.asCompiledExpression(rightNode), object, vars);
        }
        this.ensureCompleteEvaluation(rightNode, object, vars);
    }

    private boolean isEvaluated(ASTNode node) {
        return node instanceof BinaryOperation ? ((BinaryOperation)node).getLeft().getAccessor() != null : node.getAccessor() != null;
    }

    private CompiledExpression asCompiledExpression(ASTNode node) {
        return new CompiledExpression(new ASTLinkedList(node), null, Object.class, this.parserContext, false);
    }

    private boolean isCompletelyEvaluated() {
        if (this.evaluated) {
            return true;
        }
        this.evaluated = this.isCompletelyEvaluated(this.getRootNode());
        return this.evaluated;
    }

    private boolean isCompletelyEvaluated(ASTNode node) {
        if (!(node instanceof And) && !(node instanceof Or)) {
            return true;
        }
        ASTNode rightNode = ((BooleanNode)node).getRight();
        return this.isEvaluated(rightNode) && this.isCompletelyEvaluated(rightNode);
    }

    private ASTNode getRootNode() {
        return this.stmt instanceof CompiledExpression ? ((CompiledExpression)this.stmt).getFirstNode() : ((ExecutableAccessor)this.stmt).getNode();
    }
}

