/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.events;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventFeeder;
import org.drools.examples.broker.events.EventImpl;
import org.drools.examples.broker.events.EventReceiver;
import org.drools.examples.broker.events.EventSource;
import org.drools.time.TimerService;
import org.drools.time.impl.PseudoClockScheduler;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class EventFeederTest {
    @Test
    public void testFeedPseudoClock() {
        Event[] events = new Event[]{new EventImpl(1000L, (Object)"one"), new EventImpl(1100L, (Object)"two"), new EventImpl(1120L, (Object)"three"), new EventImpl(1300L, (Object)"four"), new EventImpl(1550L, (Object)"five"), new EventImpl(1700L, (Object)"six")};
        final Iterator<Event> it = Arrays.asList(events).iterator();
        EventSource source = (EventSource)Mockito.mock(EventSource.class);
        EventReceiver receiver = (EventReceiver)Mockito.mock(EventReceiver.class);
        Mockito.when((Object)source.hasNext()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return it.hasNext();
            }
        });
        Mockito.when((Object)source.getNext()).thenAnswer(new Answer<Event<?>>(){

            public Event<?> answer(InvocationOnMock invocation) throws Throwable {
                return (Event)it.next();
            }
        });
        PseudoClockScheduler clock = new PseudoClockScheduler();
        EventFeeder feeder = new EventFeeder((TimerService)clock, source, receiver);
        feeder.feed();
        for (Event event : events) {
            clock.advanceTime(event.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        }
        ((EventSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)7))).hasNext();
        ((EventSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)6))).getNext();
    }
}

