/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DroolsEditorType;
import org.drools.lang.DroolsParaphraseTypes;
import org.drools.lang.DroolsParserExceptionFactory;
import org.drools.lang.DroolsSentence;
import org.drools.lang.DroolsSentenceType;
import org.drools.lang.DroolsSoftKeywords;
import org.drools.lang.DroolsToken;
import org.drools.lang.api.AccumulateDescrBuilder;
import org.drools.lang.api.AttributeDescrBuilder;
import org.drools.lang.api.AttributeSupportBuilder;
import org.drools.lang.api.BehaviorDescrBuilder;
import org.drools.lang.api.CEDescrBuilder;
import org.drools.lang.api.CollectDescrBuilder;
import org.drools.lang.api.DeclareDescrBuilder;
import org.drools.lang.api.DescrBuilder;
import org.drools.lang.api.DescrFactory;
import org.drools.lang.api.EntryPointDeclarationDescrBuilder;
import org.drools.lang.api.EvalDescrBuilder;
import org.drools.lang.api.FieldDescrBuilder;
import org.drools.lang.api.ForallDescrBuilder;
import org.drools.lang.api.FunctionDescrBuilder;
import org.drools.lang.api.GlobalDescrBuilder;
import org.drools.lang.api.ImportDescrBuilder;
import org.drools.lang.api.PackageDescrBuilder;
import org.drools.lang.api.PatternContainerDescrBuilder;
import org.drools.lang.api.PatternDescrBuilder;
import org.drools.lang.api.QueryDescrBuilder;
import org.drools.lang.api.RuleDescrBuilder;
import org.drools.lang.api.TypeDeclarationDescrBuilder;
import org.drools.lang.api.WindowDeclarationDescrBuilder;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.PackageDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserHelper {
    public final String[] statementKeywords = new String[]{"package", "import", "global", "declare", "function", "rule", "query"};
    public List<DroolsParserException> errors = new ArrayList<DroolsParserException>();
    public LinkedList<DroolsSentence> editorInterface = null;
    public boolean isEditorInterfaceEnabled = false;
    public boolean lookaheadTest = false;
    private Stack<Map<DroolsParaphraseTypes, String>> paraphrases = new Stack();
    private DroolsParserExceptionFactory errorMessageFactory = new DroolsParserExceptionFactory(this.paraphrases);
    private TokenStream input = null;
    private RecognizerSharedState state = null;
    private String leftMostExpr = null;
    private boolean hasOperator = false;

    public ParserHelper(TokenStream input, RecognizerSharedState state) {
        this.input = input;
        this.state = state;
    }

    public LinkedList<DroolsSentence> getEditorInterface() {
        return this.editorInterface;
    }

    public void setLeftMostExpr(String value) {
        this.leftMostExpr = value;
    }

    public String getLeftMostExpr() {
        return this.leftMostExpr;
    }

    public void enableEditorInterface() {
        this.isEditorInterfaceEnabled = true;
    }

    public void disableEditorInterface() {
        this.isEditorInterfaceEnabled = false;
    }

    public void setHasOperator(boolean hasOperator) {
        this.hasOperator = hasOperator;
    }

    public boolean getHasOperator() {
        return this.hasOperator;
    }

    public void beginSentence(DroolsSentenceType sentenceType) {
        if (this.isEditorInterfaceEnabled) {
            if (null == this.editorInterface) {
                this.editorInterface = new LinkedList();
            }
            DroolsSentence sentence = new DroolsSentence();
            sentence.setType(sentenceType);
            this.editorInterface.add(sentence);
        }
    }

    public DroolsSentence getActiveSentence() {
        return this.editorInterface.getLast();
    }

    public void emit(List<?> tokens, DroolsEditorType editorType) {
        if (this.isEditorInterfaceEnabled && tokens != null) {
            for (Object activeObject : tokens) {
                this.emit((Token)activeObject, editorType);
            }
        }
    }

    public void emit(Token token, DroolsEditorType editorType) {
        if (this.isEditorInterfaceEnabled && token != null && editorType != null) {
            ((DroolsToken)token).setEditorType(editorType);
            this.getActiveSentence().addContent((DroolsToken)token);
        }
    }

    public void emit(boolean forceEmit, int activeContext) {
        if (this.isEditorInterfaceEnabled) {
            this.getActiveSentence().addContent(activeContext);
        }
    }

    public void emit(int activeContext) {
        if (this.isEditorInterfaceEnabled) {
            this.emit(false, activeContext);
        }
    }

    public DroolsToken getLastTokenOnList(LinkedList<?> list) {
        DroolsToken lastToken = null;
        for (Object object : list) {
            if (!(object instanceof DroolsToken)) continue;
            lastToken = (DroolsToken)((Object)object);
        }
        return lastToken;
    }

    public int getLastIntegerValue(LinkedList<?> list) {
        int lastIntergerValue = -1;
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            lastIntergerValue = (Integer)object;
        }
        return lastIntergerValue;
    }

    public String retrieveLT(int LTNumber) {
        if (null == this.input) {
            return null;
        }
        if (null == this.input.LT(LTNumber)) {
            return null;
        }
        if (null == this.input.LT(LTNumber).getText()) {
            return null;
        }
        return this.input.LT(LTNumber).getText();
    }

    public boolean validateLT(int LTNumber, String text) {
        String text2Validate = this.retrieveLT(LTNumber);
        return text2Validate == null ? false : text2Validate.equals(text);
    }

    public boolean isPluggableEvaluator(int offset, boolean negated) {
        String text2Validate = this.retrieveLT(offset);
        return text2Validate == null ? false : DroolsSoftKeywords.isOperator(text2Validate, negated);
    }

    public boolean isPluggableEvaluator(boolean negated) {
        return this.isPluggableEvaluator(1, negated);
    }

    public boolean validateIdentifierKey(String text) {
        return this.validateLT(1, text);
    }

    public boolean validateSpecialID(int index) {
        return this.validateLT(index, "this") || this.validateLT(index, "super") || this.validateLT(index, "new") || this.validateLT(index, "class");
    }

    public boolean validateCEKeyword(int index) {
        return this.validateLT(index, "not") || this.validateLT(index, "exists") || this.validateLT(index, "forall") || this.validateLT(index, "and") || this.validateLT(index, "or") || this.validateLT(index, "collect") || this.validateLT(index, "from") || this.validateLT(index, "end") || this.validateLT(index, "eval") || this.validateLT(index, "over") || this.validateLT(index, "then");
    }

    public boolean validateStatement(int index) {
        boolean ret = false;
        for (String st : this.statementKeywords) {
            if (!this.validateLT(index, st)) continue;
            ret = true;
            break;
        }
        return ret || this.validateAttribute(index);
    }

    public boolean validateAttribute(int index) {
        return this.validateLT(index, "salience") || this.validateLT(index, "enabled") || this.validateLT(index, "no") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "loop") || this.validateLT(index, "auto") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "focus") || this.validateLT(index, "lock") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "on") && this.validateLT(index + 3, "-") && this.validateLT(index + 4, "active") || this.validateLT(index, "agenda") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "group") || this.validateLT(index, "activation") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "group") || this.validateLT(index, "ruleflow") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "group") || this.validateLT(index, "date") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "effective") || this.validateLT(index, "date") && this.validateLT(index + 1, "-") && this.validateLT(index + 2, "expires") || this.validateLT(index, "dialect") || this.validateLT(index, "calendars") || this.validateLT(index, "timer") || this.validateLT(index, "duration") || this.validateLT(index, "refract");
    }

    public boolean validateIdentifierSufix() {
        return this.validateLT(1, "[") || this.validateLT(1, "(") || this.validateLT(1, "<") || this.validateLT(1, ".") && this.validateSpecialID(2);
    }

    public void checkTrailingSemicolon(String text, Token token) {
        if (text.trim().endsWith(";")) {
            this.errors.add(this.errorMessageFactory.createTrailingSemicolonException(((DroolsToken)token).getLine(), ((DroolsToken)token).getCharPositionInLine(), ((DroolsToken)token).getStopIndex()));
        }
    }

    public String safeSubstring(String text, int start, int end) {
        return text.substring(Math.min(start, text.length()), Math.min(Math.max(start, end), text.length()));
    }

    public void reportError(RecognitionException ex) {
        if (this.state.errorRecovery) {
            return;
        }
        this.state.errorRecovery = true;
        this.errors.add(this.errorMessageFactory.createDroolsException(ex));
    }

    public void reportError(Exception e) {
        this.errors.add(this.errorMessageFactory.createDroolsException(e, this.input.LT(1)));
    }

    public List<DroolsParserException> getErrors() {
        return this.errors;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>(this.errors.size());
        for (DroolsParserException activeException : this.errors) {
            messages.add(activeException.getMessage());
        }
        return messages;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void pushParaphrases(DroolsParaphraseTypes type) {
        HashMap<DroolsParaphraseTypes, String> activeMap = new HashMap<DroolsParaphraseTypes, String>();
        activeMap.put(type, "");
        this.paraphrases.push(activeMap);
    }

    public Map<DroolsParaphraseTypes, String> popParaphrases() {
        return this.paraphrases.pop();
    }

    public void setParaphrasesValue(DroolsParaphraseTypes type, String value) {
        this.paraphrases.peek().put(type, value);
    }

    public String buildStringFromTokens(List<Token> tokenList) {
        StringBuilder sb = new StringBuilder();
        if (null != tokenList) {
            for (Token activeToken : tokenList) {
                if (null == activeToken) continue;
                sb.append(activeToken.getText());
            }
        }
        return sb.toString();
    }

    protected void syncToSet() {
        BitSet follow = this.state.following[this.state._fsp];
        this.syncToSet(follow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncToSet(BitSet follow) {
        int mark = -1;
        try {
            mark = this.input.mark();
            while (!this.memberOfFollowSet(follow)) {
                if (this.input.LA(1) == -1) {
                    this.input.rewind();
                    mark = -1;
                    return;
                }
                this.reportError((RecognitionException)new MismatchedSetException(follow, (IntStream)this.input));
                this.input.consume();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (mark != -1) {
                this.input.release(mark);
            }
        }
    }

    private boolean memberOfFollowSet(BitSet follow) {
        boolean isMember = follow.member(this.input.LA(1));
        if (this.input.LA(1) == 67) {
            String token = this.input.LT(1).getText();
            isMember = "import".equals(token) || "global".equals(token) || "function".equals(token) || "declare".equals(token) || "rule".equals(token) || "query".equals(token) || "salience".equals(token) || "no".equals(token) || "agenda".equals(token) || "timer".equals(token) || "activation".equals(token) || "auto".equals(token) || "date".equals(token) || "enabled".equals(token) || "ruleflow".equals(token) || "dialect".equals(token) || "calendars".equals(token);
        }
        return isMember;
    }

    void setStart(DescrBuilder<?, ?> db) {
        this.setStart(db, this.input.LT(1));
    }

    void setStart(DescrBuilder<?, ?> db, Token first) {
        if (db != null && first != null) {
            db.startCharacter(((CommonToken)first).getStartIndex()).startLocation(first.getLine(), first.getCharPositionInLine());
        }
    }

    void setStart(BaseDescr descr, Token first) {
        if (descr != null && first != null) {
            descr.setLocation(first.getLine(), first.getCharPositionInLine());
            descr.setStartCharacter(((CommonToken)first).getStartIndex());
        }
    }

    void setEnd(BaseDescr descr) {
        Token last = this.input.LT(-1);
        if (descr != null && last != null) {
            int endLocation = last.getText() != null ? last.getCharPositionInLine() + last.getText().length() - 1 : last.getCharPositionInLine();
            descr.setEndCharacter(((CommonToken)last).getStopIndex() + 1);
            descr.setEndLocation(last.getLine(), endLocation);
        }
    }

    void setEnd(DescrBuilder<?, ?> db) {
        Token last = this.input.LT(-1);
        if (db != null && last != null) {
            int endLocation = last.getText() != null ? last.getCharPositionInLine() + last.getText().length() - 1 : last.getCharPositionInLine();
            db.endCharacter(((CommonToken)last).getStopIndex() + 1).endLocation(last.getLine(), endLocation);
        }
    }

    public <T extends DescrBuilder<?, ?>> T start(DescrBuilder<?, ?> ctxBuilder, Class<T> clazz, String param) {
        if (this.state.backtracking == 0) {
            if (PackageDescrBuilder.class.isAssignableFrom(clazz)) {
                this.pushParaphrases(DroolsParaphraseTypes.PACKAGE);
                this.beginSentence(DroolsSentenceType.PACKAGE);
                this.setStart(ctxBuilder);
            } else {
                if (ImportDescrBuilder.class.isAssignableFrom(clazz)) {
                    ImportDescrBuilder imp = this.validateLT(2, "function") || this.validateLT(2, "static") ? (ctxBuilder == null ? DescrFactory.newPackage().newFunctionImport() : ((PackageDescrBuilder)ctxBuilder).newFunctionImport()) : (ctxBuilder == null ? DescrFactory.newPackage().newImport() : ((PackageDescrBuilder)ctxBuilder).newImport());
                    this.pushParaphrases(DroolsParaphraseTypes.IMPORT);
                    this.beginSentence(DroolsSentenceType.IMPORT_STATEMENT);
                    this.setStart(imp);
                    return (T)imp;
                }
                if (GlobalDescrBuilder.class.isAssignableFrom(clazz)) {
                    GlobalDescrBuilder global = ctxBuilder == null ? DescrFactory.newPackage().newGlobal() : ((PackageDescrBuilder)ctxBuilder).newGlobal();
                    this.pushParaphrases(DroolsParaphraseTypes.GLOBAL);
                    this.beginSentence(DroolsSentenceType.GLOBAL);
                    this.setStart(global);
                    return (T)global;
                }
                if (DeclareDescrBuilder.class.isAssignableFrom(clazz)) {
                    DeclareDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare() : ((PackageDescrBuilder)ctxBuilder).newDeclare();
                    return (T)declare;
                }
                if (TypeDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    TypeDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().type() : ((DeclareDescrBuilder)ctxBuilder).type();
                    this.pushParaphrases(DroolsParaphraseTypes.TYPE_DECLARE);
                    this.beginSentence(DroolsSentenceType.TYPE_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (EntryPointDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    EntryPointDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().entryPoint() : ((DeclareDescrBuilder)ctxBuilder).entryPoint();
                    this.pushParaphrases(DroolsParaphraseTypes.ENTRYPOINT_DECLARE);
                    this.beginSentence(DroolsSentenceType.ENTRYPOINT_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (WindowDeclarationDescrBuilder.class.isAssignableFrom(clazz)) {
                    WindowDeclarationDescrBuilder declare = ctxBuilder == null ? DescrFactory.newPackage().newDeclare().window() : ((DeclareDescrBuilder)ctxBuilder).window();
                    this.pushParaphrases(DroolsParaphraseTypes.WINDOW_DECLARE);
                    this.beginSentence(DroolsSentenceType.WINDOW_DECLARATION);
                    this.setStart(declare);
                    return (T)declare;
                }
                if (FieldDescrBuilder.class.isAssignableFrom(clazz)) {
                    FieldDescrBuilder field = ((TypeDeclarationDescrBuilder)ctxBuilder).newField(param);
                    this.setStart(field);
                    return (T)field;
                }
                if (FunctionDescrBuilder.class.isAssignableFrom(clazz)) {
                    FunctionDescrBuilder function = null;
                    if (ctxBuilder == null) {
                        function = DescrFactory.newPackage().newFunction();
                    } else {
                        PackageDescrBuilder pkg = (PackageDescrBuilder)ctxBuilder;
                        function = pkg.newFunction().namespace(((PackageDescr)pkg.getDescr()).getName());
                        AttributeDescr attribute = ((PackageDescr)pkg.getDescr()).getAttribute("dialect");
                        if (attribute != null) {
                            function.dialect(attribute.getValue());
                        }
                    }
                    this.pushParaphrases(DroolsParaphraseTypes.FUNCTION);
                    this.beginSentence(DroolsSentenceType.FUNCTION);
                    this.setStart(function);
                    return (T)function;
                }
                if (RuleDescrBuilder.class.isAssignableFrom(clazz)) {
                    RuleDescrBuilder rule = ctxBuilder == null ? DescrFactory.newPackage().newRule() : ((PackageDescrBuilder)ctxBuilder).newRule();
                    this.pushParaphrases(DroolsParaphraseTypes.RULE);
                    this.beginSentence(DroolsSentenceType.RULE);
                    this.setStart(rule);
                    return (T)rule;
                }
                if (QueryDescrBuilder.class.isAssignableFrom(clazz)) {
                    QueryDescrBuilder query = ctxBuilder == null ? DescrFactory.newPackage().newQuery() : ((PackageDescrBuilder)ctxBuilder).newQuery();
                    this.pushParaphrases(DroolsParaphraseTypes.QUERY);
                    this.beginSentence(DroolsSentenceType.QUERY);
                    this.setStart(query);
                    return (T)query;
                }
                if (AttributeDescrBuilder.class.isAssignableFrom(clazz)) {
                    AttributeDescrBuilder attribute = ((AttributeSupportBuilder)((Object)ctxBuilder)).attribute(param);
                    this.setStart(attribute);
                    return (T)attribute;
                }
                if (EvalDescrBuilder.class.isAssignableFrom(clazz)) {
                    EvalDescrBuilder eval = ((CEDescrBuilder)ctxBuilder).eval();
                    this.pushParaphrases(DroolsParaphraseTypes.EVAL);
                    this.beginSentence(DroolsSentenceType.EVAL);
                    this.setStart(eval);
                    return (T)eval;
                }
                if (ForallDescrBuilder.class.isAssignableFrom(clazz)) {
                    ForallDescrBuilder forall = ((CEDescrBuilder)ctxBuilder).forall();
                    this.setStart(forall);
                    return (T)forall;
                }
                if (CEDescrBuilder.class.isAssignableFrom(clazz)) {
                    this.setStart(ctxBuilder);
                    return (T)ctxBuilder;
                }
                if (PatternDescrBuilder.class.isAssignableFrom(clazz)) {
                    PatternDescrBuilder pattern = ((PatternContainerDescrBuilder)((Object)ctxBuilder)).pattern();
                    this.pushParaphrases(DroolsParaphraseTypes.PATTERN);
                    this.setStart(pattern);
                    return (T)pattern;
                }
                if (CollectDescrBuilder.class.isAssignableFrom(clazz)) {
                    CollectDescrBuilder collect = ((PatternDescrBuilder)ctxBuilder).from().collect();
                    this.setStart(collect);
                    return (T)collect;
                }
                if (AccumulateDescrBuilder.class.isAssignableFrom(clazz)) {
                    AccumulateDescrBuilder accumulate = ((PatternDescrBuilder)ctxBuilder).from().accumulate();
                    this.setStart(accumulate);
                    return (T)accumulate;
                }
                if (BehaviorDescrBuilder.class.isAssignableFrom(clazz)) {
                    BehaviorDescrBuilder behavior = ((PatternDescrBuilder)ctxBuilder).behavior();
                    this.setStart(behavior);
                    return (T)behavior;
                }
            }
        }
        return null;
    }

    public <T extends DescrBuilder<?, ?>> T end(Class<T> clazz, DescrBuilder<?, ?> builder) {
        if (this.state.backtracking == 0) {
            if (!(FieldDescrBuilder.class.isAssignableFrom(clazz) || AttributeDescrBuilder.class.isAssignableFrom(clazz) || CEDescrBuilder.class.isAssignableFrom(clazz) || CollectDescrBuilder.class.isAssignableFrom(clazz) || AccumulateDescrBuilder.class.isAssignableFrom(clazz) || ForallDescrBuilder.class.isAssignableFrom(clazz) || BehaviorDescrBuilder.class.isAssignableFrom(clazz))) {
                this.popParaphrases();
            }
            this.setEnd(builder);
            return (T)builder;
        }
        return null;
    }

    public String[] getStatementKeywords() {
        return this.statementKeywords;
    }

    public boolean validateKeyword(int i) {
        String token = this.input.LT(i).getText();
        if (token != null) {
            for (Field field : DroolsSoftKeywords.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
                try {
                    if (token.equals(field.get(null))) {
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

