/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.compiler.DescrBuildError;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralRestriction;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.UnificationRestriction;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.constraint.BooleanConversionHandler;
import org.drools.rule.constraint.EvaluatorConstraint;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.Restriction;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;

public class ConstraintBuilder {
    private static final boolean USE_MVEL_EXPRESSION = true;
    private static Set<String> mvelOperators;

    private static boolean isMvelOperator(String operator) {
        return mvelOperators.contains(operator);
    }

    public static Constraint buildVariableConstraint(RuleBuildContext context, String expression, Declaration[] declarations, String leftValue, String operator, String rightValue, InternalReadAccessor extractor, Restriction restriction) {
        if (!ConstraintBuilder.isMvelOperator(operator)) {
            return new EvaluatorConstraint(restriction.getRequiredDeclarations(), restriction.getEvaluator(), extractor);
        }
        boolean isUnification = restriction instanceof UnificationRestriction;
        if (isUnification) {
            expression = ConstraintBuilder.resolveUnificationAmbiguity(expression, declarations, leftValue, rightValue, restriction);
        }
        boolean isIndexable = operator.equals("==");
        return new MvelConstraint(context.getPkg().getName(), expression, isIndexable, declarations, ConstraintBuilder.getIndexingDeclaration(restriction), extractor, isUnification);
    }

    public static Constraint buildLiteralConstraint(RuleBuildContext context, ValueType vtype, FieldValue field, String expression, String leftValue, String operator, String rightValue, InternalReadAccessor extractor, LiteralRestrictionDescr restrictionDescr) {
        if (!ConstraintBuilder.isMvelOperator(operator)) {
            Evaluator evaluator = ConstraintBuilder.buildLiteralEvaluator(context, extractor, restrictionDescr, field, vtype);
            return new EvaluatorConstraint(field, evaluator, extractor);
        }
        String mvelExpr = ConstraintBuilder.normalizeMVELLiteralExpression(vtype, field, expression, leftValue, operator, rightValue, restrictionDescr);
        return new MvelConstraint(context.getPkg().getName(), mvelExpr);
    }

    private static String resolveUnificationAmbiguity(String expr, Declaration[] declrations, String leftValue, String rightValue, Restriction restriction) {
        if (leftValue.equals(rightValue)) {
            rightValue = rightValue + "__";
            for (Declaration declaration : declrations) {
                if (!declaration.getIdentifier().equals(leftValue)) continue;
                declaration.setBindingName(rightValue);
            }
            expr = leftValue + " == " + rightValue;
        }
        return expr;
    }

    private static Declaration getIndexingDeclaration(Restriction restriction) {
        if (restriction instanceof ReturnValueRestriction) {
            return null;
        }
        Declaration[] declarations = restriction.getRequiredDeclarations();
        return declarations != null && declarations.length > 0 ? declarations[0] : null;
    }

    private static String normalizeMVELLiteralExpression(ValueType vtype, FieldValue field, String expr, String leftValue, String operator, String rightValue, LiteralRestrictionDescr restrictionDescr) {
        if (vtype == ValueType.DATE_TYPE) {
            Date date = (Date)field.getValue();
            return leftValue + " " + operator + (date != null ? " new java.util.Date(" + date.getTime() + ")" : " null");
        }
        if (operator.equals("str")) {
            String method = restrictionDescr.getParameterText();
            if (method.equals("length")) {
                return leftValue + ".length()" + (restrictionDescr.isNegated() ? " != " : " == ") + rightValue;
            }
            return (restrictionDescr.isNegated() ? "!" : "") + leftValue + "." + method + "(" + rightValue + ")";
        }
        if (expr.startsWith("empty") && (operator.equals("==") || operator.equals("!="))) {
            expr = "isEmpty()" + expr.substring(5);
        }
        return expr;
    }

    public static LiteralRestriction buildLiteralRestriction(RuleBuildContext context, InternalReadAccessor extractor, LiteralRestrictionDescr literalRestrictionDescr, FieldValue field, ValueType vtype) {
        Evaluator evaluator = ConstraintBuilder.buildLiteralEvaluator(context, extractor, literalRestrictionDescr, field, vtype);
        return evaluator == null ? null : new LiteralRestriction(field, evaluator, extractor);
    }

    public static Evaluator buildLiteralEvaluator(RuleBuildContext context, InternalReadAccessor extractor, LiteralRestrictionDescr literalRestrictionDescr, FieldValue field, ValueType vtype) {
        EvaluatorDefinition.Target right = ConstraintBuilder.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        return ConstraintBuilder.getEvaluator(context, literalRestrictionDescr, vtype, literalRestrictionDescr.getEvaluator(), literalRestrictionDescr.isNegated(), literalRestrictionDescr.getParameterText(), left, right);
    }

    public static EvaluatorDefinition.Target getRightTarget(InternalReadAccessor extractor) {
        return extractor.isSelfReference() && !Date.class.isAssignableFrom(extractor.getExtractToClass()) && !Number.class.isAssignableFrom(extractor.getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
    }

    public static Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString, boolean isNegated, String parameters, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        EvaluatorDefinition def = context.getConfiguration().getEvaluatorRegistry().getEvaluatorDefinition(evaluatorString);
        if (def == null) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the Evaluator for ID '" + evaluatorString + "'"));
            return null;
        }
        Evaluator evaluator = def.getEvaluator(valueType, evaluatorString, isNegated, parameters, left, right);
        if (evaluator == null) {
            context.addError(new DescrBuildError(context.getParentDescr(), descr, null, "Evaluator '" + (isNegated ? "not " : "") + evaluatorString + "' does not support type '" + valueType));
        }
        return evaluator;
    }

    static {
        DataConversion.addConversionHandler(Boolean.class, (ConversionHandler)BooleanConversionHandler.INSTANCE);
        DataConversion.addConversionHandler(Boolean.TYPE, (ConversionHandler)BooleanConversionHandler.INSTANCE);
        mvelOperators = new HashSet<String>(){
            {
                this.add("==");
                this.add("!=");
                this.add(">");
                this.add(">=");
                this.add("<");
                this.add("<=");
                this.add("str");
                this.add("contains");
                this.add("matches");
                this.add("excludes");
                this.add("memberOf");
            }
        };
    }
}

