/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.mvel.ActivationPropertyHandler;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.common.AgendaItem;
import org.drools.common.InstanceNotEqualsConstraint;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.conf.EventProcessingOption;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.WindowNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.GroupElement;
import org.drools.rule.IntervalProviderConstraint;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.WindowReference;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;
import org.drools.time.impl.CompositeMaxDurationTimer;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
implements ReteooComponentBuilder {
    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        context.setLastBuiltPattern(pattern);
        context.pushRuleComponent(pattern);
        this.attachPattern(context, utils, pattern);
        context.popRuleComponent();
    }

    private void attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        PropertyHandler handler;
        pattern.setOffset(context.getCurrentPatternOffset());
        if (ClassObjectType.Activation_ObjectType.isAssignableFrom(pattern.getObjectType()) && (handler = PropertyHandlerFactory.getPropertyHandler(AgendaItem.class)) == null) {
            MVELCompilationUnit.PropertyHandlerFactoryFixer.getPropertyHandlerClass().put(AgendaItem.class, new ActivationPropertyHandler());
        }
        LinkedList<AlphaNodeFieldConstraint> alphaConstraints = new LinkedList<AlphaNodeFieldConstraint>();
        LinkedList<BetaNodeFieldConstraint> betaConstraints = new LinkedList<BetaNodeFieldConstraint>();
        List<Behavior> behaviors = pattern.getBehaviors();
        this.createConstraints(context, utils, pattern, alphaConstraints, betaConstraints);
        context.setBetaconstraints(betaConstraints);
        if (pattern.getSource() != null) {
            context.setAlphaConstraints(alphaConstraints);
            int currentOffset = context.getCurrentPatternOffset();
            PatternSource source = pattern.getSource();
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            if (builder == null) {
                throw new RuntimeException("Unknown pattern source type: " + source.getClass() + " for source " + source + " on pattern " + pattern);
            }
            builder.build(context, utils, source);
            context.setCurrentPatternOffset(currentOffset);
        } else {
            EntryPoint source = EntryPoint.DEFAULT;
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            builder.build(context, utils, source);
        }
        if (pattern.getSource() == null || !(pattern.getSource() instanceof WindowReference) && (context.getCurrentEntryPoint() != EntryPoint.DEFAULT || !behaviors.isEmpty())) {
            this.attachObjectTypeNode(context, utils, pattern);
        }
        if (!behaviors.isEmpty()) {
            WindowNode wn = new WindowNode(context.getNextId(), alphaConstraints, behaviors, context.getObjectSource(), context);
            context.setObjectSource((WindowNode)utils.attachNode(context, wn));
            alphaConstraints.clear();
        }
        if (context.getObjectSource() != null) {
            this.attachAlphaNodes(context, utils, pattern, alphaConstraints);
        }
        context.incrementCurrentPatternOffset();
    }

    private void createConstraints(BuildContext context, BuildUtils utils, Pattern pattern, List<AlphaNodeFieldConstraint> alphaConstraints, List<BetaNodeFieldConstraint> betaConstraints) {
        List<Constraint> constraints = pattern.getConstraints();
        this.checkRemoveIdentities(context, pattern, betaConstraints);
        boolean isNegative = this.isNegative(context);
        for (Constraint object : constraints) {
            if (object instanceof Declaration) continue;
            Constraint constraint = object;
            if (constraint.getType().equals((Object)Constraint.ConstraintType.ALPHA)) {
                this.linkAlphaConstraint((AlphaNodeFieldConstraint)constraint, alphaConstraints);
                continue;
            }
            if (constraint.getType().equals((Object)Constraint.ConstraintType.BETA)) {
                this.linkBetaConstraint((BetaNodeFieldConstraint)constraint, betaConstraints);
                if (!isNegative || context.getRuleBase().getConfiguration().getEventProcessingMode() != EventProcessingOption.STREAM || !pattern.getObjectType().isEvent() || !constraint.isTemporal()) continue;
                this.checkDelaying(context, constraint);
                continue;
            }
            throw new RuntimeDroolsException("Unknown constraint type: " + (Object)((Object)constraint.getType()) + ". This is a bug. Please contact development team.");
        }
    }

    protected void linkBetaConstraint(BetaNodeFieldConstraint constraint, List<BetaNodeFieldConstraint> betaConstraints) {
        betaConstraints.add(constraint);
    }

    protected void linkAlphaConstraint(AlphaNodeFieldConstraint constraint, List<AlphaNodeFieldConstraint> alphaConstraints) {
        alphaConstraints.add(constraint);
    }

    private void checkDelaying(BuildContext context, Constraint constraint) {
        long uplimit;
        Declaration target;
        if (constraint instanceof IntervalProviderConstraint && (target = constraint.getRequiredDeclarations()[0]).isPatternDeclaration() && target.getPattern().getObjectType().isEvent() && (uplimit = ((IntervalProviderConstraint)constraint).getInterval().getUpperBound()) < Long.MAX_VALUE) {
            Timer timer = context.getRule().getTimer();
            DurationTimer durationTimer = new DurationTimer(uplimit);
            if (timer instanceof CompositeMaxDurationTimer) {
                ((CompositeMaxDurationTimer)timer).addDurationTimer(durationTimer);
            } else {
                if (timer == null) {
                    timer = durationTimer;
                } else {
                    CompositeMaxDurationTimer temp = new CompositeMaxDurationTimer();
                    if (timer instanceof DurationTimer) {
                        temp.addDurationTimer((DurationTimer)timer);
                    } else {
                        temp.setTimer(context.getRule().getTimer());
                    }
                    temp.addDurationTimer(durationTimer);
                    timer = temp;
                }
                context.getRule().setTimer(timer);
            }
        }
    }

    private boolean isNegative(BuildContext context) {
        ListIterator<RuleConditionElement> it = context.stackIterator();
        while (it.hasPrevious()) {
            RuleConditionElement rce = it.previous();
            if (!(rce instanceof GroupElement) || !((GroupElement)rce).isNot()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeNode attachObjectTypeNode(BuildContext context, ObjectType objectType) {
        ObjectTypeNode objectTypeNode;
        InternalRuleBase ruleBase = context.getRuleBase();
        ruleBase.lock();
        try {
            InternalWorkingMemory[] wms = context.getWorkingMemories();
            EntryPointNode epn = ruleBase.getRete().getEntryPointNode(context.getCurrentEntryPoint());
            if (epn == null) {
                epn = new EntryPointNode(context.getNextId(), ruleBase.getRete(), context);
                epn.attach(context);
            }
            ObjectTypeNode otn = new ObjectTypeNode(context.getNextId(), epn, objectType, context);
            long expirationOffset = PatternBuilder.getExpiratioOffsetForType(context, objectType);
            otn.setExpirationOffset(expirationOffset);
            otn.attach(context);
            objectTypeNode = otn;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            ruleBase.unlock();
            throw throwable;
        }
        ruleBase.unlock();
        return objectTypeNode;
    }

    private static long getExpiratioOffsetForType(BuildContext context, ObjectType objectType) {
        long expirationOffset = -1L;
        for (TypeDeclaration type : context.getRuleBase().getTypeDeclarations()) {
            if (!type.getObjectType().isAssignableFrom(objectType)) continue;
            expirationOffset = Math.max(type.getExpirationOffset(), expirationOffset);
        }
        return expirationOffset == -1L ? -1L : expirationOffset + 1L;
    }

    public void attachAlphaNodes(BuildContext context, BuildUtils utils, Pattern pattern, List<AlphaNodeFieldConstraint> alphaConstraints) throws InvalidPatternException {
        boolean alphaMemory = context.isAlphaMemoryAllowed();
        this.buildAlphaNodeChain(context, utils, pattern, alphaConstraints);
        if (context.getCurrentEntryPoint() != EntryPoint.DEFAULT && context.isAttachPQN()) {
            context.setObjectSource((ObjectSource)utils.attachNode(context, new PropagationQueuingNode(context.getNextId(), context.getObjectSource(), context)));
            context.setCurrentEntryPoint(EntryPoint.DEFAULT);
        }
        context.setAlphaNodeMemoryAllowed(alphaMemory);
    }

    protected void buildAlphaNodeChain(BuildContext context, BuildUtils utils, Pattern pattern, List<AlphaNodeFieldConstraint> alphaConstraints) {
        for (AlphaNodeFieldConstraint constraint : alphaConstraints) {
            context.pushRuleComponent(constraint);
            context.setObjectSource((ObjectSource)utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildAlphaNode(context.getNextId(), constraint, context.getObjectSource(), context)));
            context.popRuleComponent();
        }
    }

    private void attachObjectTypeNode(BuildContext context, BuildUtils utils, Pattern pattern) {
        boolean objectMemory = context.isObjectTypeNodeMemoryEnabled();
        ObjectType objectType = pattern.getObjectType();
        if (pattern.getObjectType() instanceof ClassObjectType && DroolsQuery.class == ((ClassObjectType)pattern.getObjectType()).getClassType()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
            context.setAlphaNodeMemoryAllowed(false);
        }
        ObjectTypeNode otn = context.getComponentFactory().getNodeFactoryService().buildObjectTypeNode(context.getNextId(), (EntryPointNode)context.getObjectSource(), objectType, context);
        if (objectType.isEvent() && EventProcessingOption.STREAM.equals((Object)context.getRuleBase().getConfiguration().getEventProcessingMode())) {
            long expirationOffset = PatternBuilder.getExpiratioOffsetForType(context, objectType);
            if (expirationOffset != -1L) {
                otn.setExpirationOffset(expirationOffset);
            } else {
                long distance;
                for (Behavior behavior : pattern.getBehaviors()) {
                    if (behavior.getExpirationOffset() == -1L) continue;
                    expirationOffset = Math.max(behavior.getExpirationOffset(), expirationOffset);
                }
                long l = distance = context.getTemporalDistance() != null ? context.getTemporalDistance().getExpirationOffset(pattern) : -1L;
                if (distance == -1L) {
                    otn.setExpirationOffset(expirationOffset);
                } else {
                    otn.setExpirationOffset(Math.max(distance, expirationOffset));
                }
            }
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, otn));
        context.setObjectTypeNodeMemoryEnabled(objectMemory);
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List<BetaNodeFieldConstraint> betaConstraints) {
        if (context.getRuleBase().getConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            Class<?> thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
            for (Pattern previousPattern : context.getObjectType()) {
                Class<?> previousClass = ((ClassObjectType)previousPattern.getObjectType()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                betaConstraints.add(new InstanceNotEqualsConstraint(previousPattern));
            }
            context.getObjectType().add(pattern);
        }
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return ((Pattern)rce).getSource() != null || !((Pattern)rce).getBehaviors().isEmpty();
    }
}

