/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.decisiontable;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.examples.decisiontable.Driver;
import org.drools.examples.decisiontable.Policy;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ByteArrayResource;
import org.drools.runtime.StatefulKnowledgeSession;

public class PricingRuleTemplateExample {
    public static void main(String[] args) {
        PricingRuleTemplateExample launcher = new PricingRuleTemplateExample();
        launcher.executeExample();
    }

    private int executeExample() {
        KnowledgeBase kbase = this.buildKBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        ksession.insert(driver);
        ksession.insert(policy);
        ksession.fireAllRules();
        System.out.println("BASE PRICE IS: " + policy.getBasePrice());
        System.out.println("DISCOUNT IS: " + policy.getDiscountPercent());
        ksession.dispose();
        return policy.getBasePrice();
    }

    private KnowledgeBase buildKBase() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String basePricingDRL = null;
        String promotionalPricingDRL = null;
        try {
            basePricingDRL = converter.compile(this.getSpreadsheetStream(), this.getBasePricingRulesStream(), 10, 3);
            promotionalPricingDRL = converter.compile(this.getSpreadsheetStream(), this.getPromotionalPricingRulesStream(), 30, 3);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid spreadsheet stream.", e);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(basePricingDRL.getBytes()), ResourceType.DRL);
        kbuilder.add((Resource)new ByteArrayResource(promotionalPricingDRL.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println("Error compiling resources:");
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                System.out.println("\t" + ((KnowledgeBuilderError)errors.next()).getMessage());
            }
            throw new IllegalStateException("Error compiling resources");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private InputStream getSpreadsheetStream() throws IOException {
        return ResourceFactory.newClassPathResource("org/drools/examples/decisiontable/ExamplePolicyPricing.xls").getInputStream();
    }

    private InputStream getBasePricingRulesStream() throws IOException {
        return ResourceFactory.newClassPathResource("org/drools/examples/decisiontable/BasePricing.drt").getInputStream();
    }

    private InputStream getPromotionalPricingRulesStream() throws IOException {
        return ResourceFactory.newClassPathResource("org/drools/examples/decisiontable/PromotionalPricing.drt").getInputStream();
    }
}

