/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.pacman;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.examples.pacman.Cell;
import org.drools.examples.pacman.CellContents;
import org.drools.examples.pacman.CellType;
import org.drools.examples.pacman.Location;
import org.drools.examples.pacman.Monster;
import org.drools.examples.pacman.PacMan;
import org.drools.examples.pacman.PacmanGui;
import org.drools.examples.pacman.Score;
import org.drools.examples.pacman.Tick;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public class PacmanExample {
    volatile StatefulKnowledgeSession ksession = null;
    PacMan pacMan;

    public static void main(String[] args) {
        new PacmanExample().init(true);
    }

    public void init(boolean exitOnClose) {
        this.initKsession();
        this.buildGrid();
        this.initGui(exitOnClose);
        this.runKSession();
    }

    public void initKsession() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource("base.drl", this.getClass()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource("key-handlers.drl", this.getClass()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource("pacman.drl", this.getClass()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource("monster.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        this.ksession = kbase.newStatefulKnowledgeSession();
        this.pacMan = new PacMan();
        this.pacMan.setSpeed(3);
        this.ksession.insert(this.pacMan);
        Monster monster = new Monster();
        monster.setSpeed(5);
        this.ksession.insert(monster);
        this.ksession.insert(new Score());
        Location pacLocation = new Location(this.pacMan, 1, 5);
        Location monLocation = new Location(monster, 10, 5);
        this.ksession.insert(pacLocation);
        this.ksession.insert(monLocation);
        Tick tick = new Tick(0);
        this.ksession.insert(tick);
    }

    public void buildGrid() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(ResourceFactory.newClassPathResource("grid1.dat", PacmanExample.class).getReader());
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading dat file failed.", e);
        }
        for (int row = lines.size() - 1; row >= 0; --row) {
            String line = (String)lines.get(row);
            int whiteCellCount = 0;
            for (int col = 0; col < line.length(); ++col) {
                char c = line.charAt(col);
                Cell cell = new Cell(lines.size() - row - 1, col - whiteCellCount);
                CellContents contents = null;
                switch (c) {
                    case '*': {
                        contents = new CellContents(cell, CellType.WALL);
                        break;
                    }
                    case '.': {
                        contents = new CellContents(cell, CellType.FOOD);
                        break;
                    }
                    case '#': {
                        contents = new CellContents(cell, CellType.POWER_PILL);
                        break;
                    }
                    case '_': {
                        contents = new CellContents(cell, CellType.EMPTY);
                        break;
                    }
                    case ' ': {
                        ++whiteCellCount;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("'" + c + "' is an invalid cell type");
                    }
                }
                if (contents == null) continue;
                System.out.println(cell + " : " + contents);
                this.ksession.insert(cell);
                this.ksession.insert(contents);
            }
        }
    }

    public void initGui(boolean exitOnClose) {
        PacmanGui.createAndShowGUI(this.ksession, exitOnClose);
    }

    public void runKSession() {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.submit(new Runnable(){

            public void run() {
                PacmanExample.this.ksession.fireUntilHalt();
            }
        });
    }
}

