/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.workitemconsequence;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.rule.FactHandle;

public class WorkItemConsequenceExample1 {
    public static void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource("WorkItemConsequence1.drl", WorkItemConsequenceExample1.class), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Compilation error.\n" + kbuilder.getErrors().toString());
        }
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.getWorkItemManager().registerWorkItemHandler("EmailWorkItemHandler", new EmailWorkItemHandler());
        PersonLocation brains = new PersonLocation("Brains", 5L);
        ksession.insert(brains);
        ksession.fireAllRules();
        PersonLocation gargamel = new PersonLocation("Gargamel", 10L);
        FactHandle gargamelFactHandle = ksession.insert(gargamel);
        ksession.fireAllRules();
        gargamel.setDistance(5L);
        ksession.update(gargamelFactHandle, gargamel);
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static class EmailWorkItemHandler
    implements WorkItemHandler {
        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            String emailAddress = (String)workItem.getParameter("emailAddress");
            String message = (String)workItem.getParameter("message");
            System.out.println("to: " + emailAddress + " --> " + message);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    public static class Email {
        private String emailAddress;
        private String message;

        public Email(String emailAddress, String message) {
            this.emailAddress = emailAddress;
            this.message = message;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class PersonLocation {
        private String name;
        private long distance;

        public PersonLocation(String name, long distance) {
            this.name = name;
            this.distance = distance;
        }

        public String getName() {
            return this.name;
        }

        public void setDistance(long distance) {
            this.distance = distance;
        }

        public long getDistance() {
            return this.distance;
        }
    }
}

