/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.wumpus;

import java.util.Random;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.games.wumpus.WumpusWorldConfiguration;
import org.drools.games.wumpus.view.GameView;
import org.drools.io.ResourceFactory;
import org.drools.runtime.Channel;
import org.drools.runtime.StatefulKnowledgeSession;

public class WumpusWorldMain {
    public static void main(String[] args) {
        new WumpusWorldMain().init(true);
    }

    public void init(boolean exitOnClose) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().add(ResourceFactory.newClassPathResource("init.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource("commands.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource("shoot.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource("ui.drl", GameView.class), ResourceType.DRL).add(ResourceFactory.newClassPathResource("paintCave.drl", GameView.class), ResourceType.DRL).add(ResourceFactory.newClassPathResource("paintSensor.drl", GameView.class), ResourceType.DRL).add(ResourceFactory.newClassPathResource("score.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource("sensorArray.drl", this.getClass()), ResourceType.DRL).build();
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase serverKBase = KnowledgeBaseFactory.newKnowledgeBase();
        serverKBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().add(ResourceFactory.newClassPathResource("client.drl", this.getClass()), ResourceType.DRL).build();
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase clientKBase = KnowledgeBaseFactory.newKnowledgeBase();
        clientKBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        final StatefulKnowledgeSession serverKsession = serverKBase.newStatefulKnowledgeSession();
        final StatefulKnowledgeSession clientKsession = clientKBase.newStatefulKnowledgeSession();
        serverKsession.getChannels().put("sensors", new Channel(){

            public void send(Object object) {
                clientKsession.insert(object);
                clientKsession.fireAllRules();
            }
        });
        clientKsession.getChannels().put("commands", new Channel(){

            public void send(Object object) {
                serverKsession.insert(object);
                serverKsession.fireAllRules();
            }
        });
        WumpusWorldConfiguration wumpusWorldConfiguration = new WumpusWorldConfiguration();
        wumpusWorldConfiguration.setExitOnClose(exitOnClose);
        serverKsession.setGlobal("wumpusWorldConfiguration", wumpusWorldConfiguration);
        serverKsession.setGlobal("randomInteger", new Random());
        serverKsession.fireAllRules();
        clientKsession.fireAllRules();
    }
}

