/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;

public class DefaultDSLMapping
implements DSLMapping {
    private String identifier;
    private String description;
    private List<DSLMappingEntry> entries;
    private Set<String> options;

    public DefaultDSLMapping() {
        this("");
    }

    public DefaultDSLMapping(String identifier) {
        this.identifier = identifier;
        this.entries = new LinkedList<DSLMappingEntry>();
        this.options = new HashSet<String>();
    }

    @Override
    public void addEntry(DSLMappingEntry entry) {
        this.entries.add(entry);
    }

    @Override
    public void addEntries(List<DSLMappingEntry> entries) {
        this.entries.addAll(entries);
    }

    @Override
    public List<DSLMappingEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    @Override
    public List<DSLMappingEntry> getEntries(DSLMappingEntry.Section section) {
        LinkedList<DSLMappingEntry> list = new LinkedList<DSLMappingEntry>();
        for (DSLMappingEntry entry : this.entries) {
            if (!entry.getSection().equals((Object)section)) continue;
            list.add(entry);
        }
        return list;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void removeEntry(DSLMappingEntry entry) {
        this.entries.remove(entry);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public void setOptions(Collection<String> option) {
        this.options.addAll(option);
    }

    @Override
    public boolean getOption(String option) {
        return this.options.contains(option);
    }
}

