/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.kie.builder.impl.FormatConverter;
import org.kie.io.ResourceType;

public class FormatsManager {
    private static final FormatsManager INSTANCE = new FormatsManager();
    private Map<String, String> registry = new HashMap<String, String>(){
        {
            this.put("gdst", "org.kie.guvnor.guided.dtable.backend.server.GuidedDecisionTableConverter");
        }
    };
    private Map<String, FormatConverter> converters = new HashMap<String, FormatConverter>();

    private FormatsManager() {
    }

    static FormatsManager get() {
        return INSTANCE;
    }

    public FormatConverter getConverterFor(String fileName) {
        return FormatsManager.isKieExtension(fileName) ? FormatConverter.DummyConverter.INSTANCE : this.getExternalConverter(fileName);
    }

    private FormatConverter getExternalConverter(String fileName) {
        String converterClassName;
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos < 0) {
            return null;
        }
        String extension = fileName.substring(dotPos + 1);
        FormatConverter converter = this.converters.get(extension);
        if (converter == null && (converterClassName = this.registry.get(extension)) != null) {
            try {
                converter = (FormatConverter)Class.forName(converterClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return converter;
    }

    static boolean isKieExtension(String fileName) {
        return !fileName.endsWith(".java") && ResourceType.determineResourceType((String)fileName) != null;
    }
}

