/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.commons.jci.problems.CompilationProblem;
import org.kie.builder.KnowledgeBuilderResult;
import org.kie.builder.Message;

public class MessageImpl
implements Message {
    private final long id;
    private final Message.Level level;
    private final String path;
    private final int line;
    private final int column;
    private final String text;

    public MessageImpl(long id, Message.Level level, String path, String text) {
        this.id = id;
        this.level = level;
        this.path = path;
        this.text = text;
        this.line = 0;
        this.column = 0;
    }

    public MessageImpl(long id, CompilationProblem problem) {
        this.id = id;
        this.level = problem.isError() ? Message.Level.ERROR : Message.Level.WARNING;
        this.path = problem.getFileName();
        this.line = problem.getStartLine();
        this.column = problem.getStartColumn();
        this.text = problem.getMessage();
    }

    public MessageImpl(long id, KnowledgeBuilderResult result) {
        this.id = id;
        switch (result.getSeverity()) {
            case ERROR: {
                this.level = Message.Level.ERROR;
                break;
            }
            case WARNING: {
                this.level = Message.Level.WARNING;
                break;
            }
            default: {
                this.level = Message.Level.INFO;
            }
        }
        this.path = result.getResource().getSourcePath();
        this.line = result.getLines()[0];
        this.column = 0;
        this.text = result.getMessage();
    }

    public long getId() {
        return this.id;
    }

    public Message.Level getLevel() {
        return this.level;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public static List<Message> filterMessages(List<Message> messages, Message.Level ... levels) {
        ArrayList<Message> filteredMsgs = new ArrayList<Message>();
        if (levels != null && levels.length > 0) {
            for (Message.Level level : levels) {
                for (Message msg : messages) {
                    if (msg.getLevel() != level) continue;
                    filteredMsgs.add(msg);
                }
            }
        }
        return filteredMsgs;
    }

    public String toString() {
        return "Message [id=" + this.id + ", level=" + this.level + ", path=" + this.path + ", line=" + this.line + ", column=" + this.column + "\n   text=" + this.text + "]";
    }
}

