/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import org.drools.lang.descr.BaseDescr;
import org.drools.verifier.components.ChildComponent;
import org.drools.verifier.components.PackageComponent;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.components.VerifierRule;

public abstract class RuleComponent<D extends BaseDescr>
extends PackageComponent<D>
implements ChildComponent {
    private String ruleName;
    private VerifierComponentType parentType;
    private String parentPath;
    private int orderNumber;

    public RuleComponent(VerifierRule rule) {
        this(rule.getDescr(), rule.getPackageName(), rule.getName());
    }

    RuleComponent(D descr, String packageName, String ruleName) {
        super(descr, packageName);
        this.setRuleName(ruleName);
    }

    public String getFullRulePath() {
        return this.getPackageName() + "/" + this.getRuleName();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    protected void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRulePath() {
        return String.format("%s/rule[@name='%s']", this.getPackagePath(), this.getRuleName());
    }

    @Override
    public String getPath() {
        return String.format("%s/ruleComponent[%s]", this.getRulePath(), this.getOrderNumber());
    }

    @Override
    public VerifierComponentType getParentType() {
        return this.parentType;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public int getOrderNumber() {
        return this.orderNumber;
    }

    public void setParentType(VerifierComponentType parentType) {
        this.parentType = parentType;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }
}

