/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.DeclarativeInvokerDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.verifier.components.EntryPoint;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.FieldVariable;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternEval;
import org.drools.verifier.components.PatternOperatorDescr;
import org.drools.verifier.components.PatternVariable;
import org.drools.verifier.components.VerifierAccumulateDescr;
import org.drools.verifier.components.VerifierCollectDescr;
import org.drools.verifier.components.VerifierFromDescr;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.components.WorkingMemory;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.solver.Solvers;
import org.drools.verifier.visitor.ConditionalElementDescrVisitor;
import org.drools.verifier.visitor.DeclarativeInvokerDescrVisitor;
import org.drools.verifier.visitor.ExprConstraintDescrVisitor;
import org.drools.verifier.visitor.FieldConstraintDescrVisitor;
import org.drools.verifier.visitor.ObjectTypeFactory;
import org.drools.verifier.visitor.UnknownDescriptionException;

public class PatternDescrVisitor
extends ConditionalElementDescrVisitor {
    private ObjectType objectType;
    private Pattern pattern;
    private WorkingMemory workingMemory = null;

    public PatternDescrVisitor(VerifierData data, VerifierRule rule, Solvers solvers) {
        super(data, solvers);
        this.rule = rule;
    }

    public void visit(PatternDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        this.visitPatternDescr(descr, parent, orderNumber);
    }

    public void visit(PatternDescr descr, int orderNumber) throws UnknownDescriptionException {
        this.visitPatternDescr(descr, null, orderNumber);
    }

    private Pattern visitPatternDescr(PatternDescr descr, VerifierComponent parent, int orderNumber) throws UnknownDescriptionException {
        this.objectType = this.data.getObjectTypeByFullName(descr.getObjectType());
        if (this.objectType == null) {
            Import objectImport = this.data.getImportByName(descr.getObjectType());
            this.objectType = objectImport != null ? ObjectTypeFactory.createObjectType((BaseDescr)descr, objectImport) : ObjectTypeFactory.createObjectType((BaseDescr)descr, descr.getObjectType());
            this.data.add(this.objectType);
        }
        this.pattern = new Pattern(descr, this.rule);
        if (parent != null) {
            this.pattern.setParentPath(parent.getPath());
            this.pattern.setParentType(parent.getVerifierComponentType());
        }
        this.pattern.setObjectTypePath(this.objectType.getPath());
        this.pattern.setName(this.objectType.getName());
        this.pattern.setPatternNot(this.solvers.getRuleSolver().isChildNot());
        this.pattern.setPatternExists(this.solvers.getRuleSolver().isExists());
        this.pattern.setPatternForall(this.solvers.getRuleSolver().isForall());
        this.pattern.setOrderNumber(orderNumber);
        if (descr.getIdentifier() != null) {
            PatternVariable patternVariable = new PatternVariable(this.rule);
            patternVariable.setName(descr.getIdentifier());
            patternVariable.setParentPath(this.pattern.getPath());
            patternVariable.setParentType(this.pattern.getVerifierComponentType());
            this.data.add(patternVariable);
        }
        if (descr.getSource() != null) {
            this.visit(descr.getSource());
        } else {
            if (this.workingMemory == null) {
                this.workingMemory = new WorkingMemory();
                this.data.add(this.workingMemory);
            }
            this.pattern.setSourcePath(this.workingMemory.getPath());
            this.pattern.setSourceType(this.workingMemory.getVerifierComponentType());
        }
        this.solvers.startPatternSolver(this.pattern);
        this.visit(descr.getConstraint());
        this.solvers.endPatternSolver();
        this.data.add(this.pattern);
        return this.pattern;
    }

    @Override
    protected VerifierComponent getParent() {
        return this.pattern;
    }

    @Override
    protected void visit(Object descr) throws UnknownDescriptionException {
        if (descr instanceof AccumulateDescr) {
            this.visitAccumulateDescr((AccumulateDescr)descr);
        } else if (descr instanceof CollectDescr) {
            this.visitCollectDescr((CollectDescr)descr);
        } else if (descr instanceof EntryPointDescr) {
            this.visitEntryPointDescr((EntryPointDescr)descr);
        } else if (descr instanceof FromDescr) {
            this.visitFromDescr((FromDescr)descr);
        } else if (descr instanceof AndDescr) {
            this.visitAndDescr((AndDescr)descr);
        } else if (descr instanceof OrDescr) {
            this.visitOrDescr((OrDescr)descr);
        } else if (descr instanceof FieldConstraintDescr) {
            this.visitFieldConstraintDescr((FieldConstraintDescr)descr);
        } else if (descr instanceof BindingDescr) {
            this.visitBindingDescr((BindingDescr)descr);
        } else if (descr instanceof PredicateDescr) {
            this.visitPredicateDescr((PredicateDescr)descr);
        } else if (descr instanceof ExprConstraintDescr) {
            this.visit((ExprConstraintDescr)descr);
        } else {
            throw new UnknownDescriptionException((BaseDescr)descr);
        }
    }

    private void visit(ExprConstraintDescr descr) {
        ExprConstraintDescrVisitor exprConstraintDescrVisitor = new ExprConstraintDescrVisitor(this.pattern, this.data, this.orderNumber, this.solvers);
        exprConstraintDescrVisitor.visit(descr);
    }

    private PatternEval visitPredicateDescr(PredicateDescr descr) {
        PatternEval predicate = new PatternEval(this.pattern);
        predicate.setContent(descr.getContent().toString());
        predicate.setClassMethodName(descr.getClassMethodName());
        predicate.setOrderNumber(this.orderNumber.next());
        predicate.setParentPath(this.pattern.getPath());
        predicate.setParentType(this.pattern.getVerifierComponentType());
        this.data.add(predicate);
        this.solvers.addPatternComponent(predicate);
        return predicate;
    }

    private void visitBindingDescr(BindingDescr descr) {
        Field field = new Field((BaseDescr)descr);
        field.setName(descr.getExpression());
        field.setObjectTypeName(this.objectType.getName());
        field.setObjectTypePath(this.objectType.getPath());
        this.data.add(field);
        FieldVariable fieldVariable = new FieldVariable(this.pattern);
        fieldVariable.setParentPath(field.getPath());
        fieldVariable.setName(descr.getVariable());
        fieldVariable.setOrderNumber(this.orderNumber.next());
        this.data.add(fieldVariable);
    }

    private void visitFieldConstraintDescr(FieldConstraintDescr descr) throws UnknownDescriptionException {
        FieldConstraintDescrVisitor visitor = new FieldConstraintDescrVisitor(this.data, this.pattern, this.solvers, this.orderNumber.next());
        visitor.visitFieldConstraintDescr(descr);
    }

    private void visitEntryPointDescr(EntryPointDescr descr) throws UnknownDescriptionException {
        EntryPoint entryPoint = this.data.getEntryPointByEntryId(descr.getEntryId());
        if (entryPoint == null) {
            entryPoint = new EntryPoint((BaseDescr)descr);
            entryPoint.setEntryPointName(descr.getEntryId());
            this.data.add(entryPoint);
        }
        this.pattern.setSourcePath(entryPoint.getPath());
        this.pattern.setSourceType(entryPoint.getVerifierComponentType());
    }

    private VerifierFromDescr visitFromDescr(FromDescr descr) throws UnknownDescriptionException {
        VerifierFromDescr from = new VerifierFromDescr(this.pattern);
        VerifierComponent ds = this.visit(descr.getDataSource());
        from.setDataSourcePath(ds.getPath());
        from.setDataSourceType(ds.getVerifierComponentType());
        from.setParentPath(this.rule.getPath());
        from.setParentType(this.rule.getVerifierComponentType());
        this.data.add(from);
        return from;
    }

    private VerifierCollectDescr visitCollectDescr(CollectDescr descr) throws UnknownDescriptionException {
        VerifierCollectDescr collect = new VerifierCollectDescr(this.pattern);
        collect.setClassMethodName(descr.getClassMethodName());
        PatternDescrVisitor visitor = new PatternDescrVisitor(this.data, this.rule, this.solvers);
        visitor.visit(descr.getInputPattern(), collect, 0);
        collect.setParentPath(this.rule.getPath());
        collect.setParentType(this.rule.getVerifierComponentType());
        this.data.add(collect);
        return collect;
    }

    private VerifierAccumulateDescr visitAccumulateDescr(AccumulateDescr descr) throws UnknownDescriptionException {
        VerifierAccumulateDescr accumulate = new VerifierAccumulateDescr(this.pattern);
        PatternDescrVisitor visitor = new PatternDescrVisitor(this.data, this.rule, this.solvers);
        Pattern parentPattern = visitor.visitPatternDescr(descr.getInputPattern(), null, 0);
        accumulate.setInitCode(descr.getInitCode());
        accumulate.setActionCode(descr.getActionCode());
        accumulate.setReverseCode(descr.getReverseCode());
        accumulate.setResultCode(descr.getResultCode());
        accumulate.setClassName(descr.getClassName());
        accumulate.setExternalFunction(descr.isExternalFunction());
        accumulate.setFunctionIdentifier(((AccumulateDescr.AccumulateFunctionCallDescr)descr.getFunctions().get(0)).getFunction());
        accumulate.setExpression(((AccumulateDescr.AccumulateFunctionCallDescr)descr.getFunctions().get(0)).getParams()[0]);
        accumulate.setParentPath(parentPattern.getPath());
        accumulate.setParentType(parentPattern.getVerifierComponentType());
        this.data.add(accumulate);
        return accumulate;
    }

    protected VerifierComponent visit(DeclarativeInvokerDescr descr) throws UnknownDescriptionException {
        DeclarativeInvokerDescrVisitor visitor = new DeclarativeInvokerDescrVisitor(this.data, this.rule);
        return visitor.visit(descr);
    }

    @Override
    protected void visitAndDescr(AndDescr descr) throws UnknownDescriptionException {
        PatternOperatorDescr operatorDescr = new PatternOperatorDescr(this.pattern, OperatorDescrType.AND);
        operatorDescr.setOrderNumber(this.orderNumber.next());
        operatorDescr.setParentPath(this.getParent().getPath());
        operatorDescr.setParentType(this.getParent().getVerifierComponentType());
        this.data.add(operatorDescr);
        this.solvers.startOperator(OperatorDescrType.AND);
        this.visit(descr.getDescrs());
        this.solvers.endOperator();
    }

    @Override
    protected void visitOrDescr(OrDescr descr) throws UnknownDescriptionException {
        PatternOperatorDescr operatorDescr = new PatternOperatorDescr(this.pattern, OperatorDescrType.OR);
        operatorDescr.setOrderNumber(this.orderNumber.next());
        this.data.add(operatorDescr);
        this.solvers.startOperator(OperatorDescrType.OR);
        this.visit(descr.getDescrs());
        this.solvers.endOperator();
    }
}

