/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.rules.InvalidRuleSessionException;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleSessionCreateException;
import javax.rules.StatelessRuleSession;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.jsr94.rules.AbstractRuleSessionImpl;
import org.drools.jsr94.rules.IteratorToList;
import org.drools.jsr94.rules.ObjectFilterAdapter;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepository;
import org.drools.jsr94.rules.repository.RuleExecutionSetRepositoryException;
import org.kie.runtime.ObjectFilter;

public class StatelessRuleSessionImpl
extends AbstractRuleSessionImpl
implements StatelessRuleSession {
    StatelessRuleSessionImpl(String bindUri, Map properties, RuleExecutionSetRepository repository) throws RuleExecutionSetNotFoundException, RuleSessionCreateException {
        super(repository);
        this.setProperties(properties);
        RuleExecutionSetImpl ruleSet = null;
        try {
            ruleSet = (RuleExecutionSetImpl)repository.getRuleExecutionSet(bindUri, properties);
        }
        catch (RuleExecutionSetRepositoryException e) {
            String s = "Error while retrieving rule execution set bound to: " + bindUri;
            throw new RuleSessionCreateException(s, (Exception)((Object)e));
        }
        if (ruleSet == null) {
            throw new RuleExecutionSetNotFoundException("RuleExecutionSet unbound: " + bindUri);
        }
        this.setRuleExecutionSet(ruleSet);
    }

    protected StatelessSession newStatelessSession() {
        StatelessSession session = this.getRuleExecutionSet().newStatelessSession();
        Map props = this.getProperties();
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                session.setGlobal((String)entry.getKey(), entry.getValue());
            }
        }
        return session;
    }

    public List executeRules(List objects) throws InvalidRuleSessionException {
        return this.executeRules(objects, this.getRuleExecutionSet().getObjectFilter());
    }

    public List executeRules(List objects, javax.rules.ObjectFilter filter) throws InvalidRuleSessionException {
        StatelessSession session = this.newStatelessSession();
        StatelessSessionResult results = session.executeWithResults((Collection)objects);
        return IteratorToList.convert(results.iterateObjects((ObjectFilter)new ObjectFilterAdapter(filter)));
    }

    public int getType() throws InvalidRuleSessionException {
        return 1;
    }

    @Override
    protected void checkRuleSessionValidity() throws InvalidRuleSessionException {
        if (this.getRuleExecutionSet() == null) {
            throw new InvalidRuleSessionException("invalid rule session");
        }
    }
}

