/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.SessionConfiguration;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.base.MapGlobalResolver;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalStatelessSession;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaEventSupport;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.impl.EnvironmentFactory;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.ReteStatelessSessionResult;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.spi.AgendaFilter;
import org.drools.spi.GlobalExporter;
import org.drools.spi.GlobalResolver;

public class ReteooStatelessSession
implements StatelessSession,
InternalStatelessSession,
Externalizable {
    private InternalRuleBase ruleBase;
    private AgendaFilter agendaFilter;
    private GlobalResolver globalResolver = new MapGlobalResolver();
    private GlobalExporter globalExporter;
    private SessionConfiguration sessionConf;
    protected WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport();
    protected AgendaEventSupport agendaEventSupport = new AgendaEventSupport();

    public ReteooStatelessSession() {
    }

    public ReteooStatelessSession(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.sessionConf = SessionConfiguration.getDefaultInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ruleBase = (InternalRuleBase)in.readObject();
        this.agendaFilter = (AgendaFilter)in.readObject();
        this.globalResolver = (GlobalResolver)in.readObject();
        this.globalExporter = (GlobalExporter)in.readObject();
        this.sessionConf = SessionConfiguration.getDefaultInstance();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ruleBase);
        out.writeObject(this.agendaFilter);
        out.writeObject(this.globalResolver);
        out.writeObject(this.globalExporter);
    }

    @Override
    public InternalRuleBase getRuleBase() {
        return this.ruleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalWorkingMemory newWorkingMemory() {
        this.ruleBase.readLock();
        try {
            ReteooWorkingMemory wm = new ReteooWorkingMemory(this.ruleBase.nextWorkingMemoryCounter(), this.ruleBase, this.sessionConf, EnvironmentFactory.newEnvironment(), this.workingMemoryEventSupport, this.agendaEventSupport);
            wm.setGlobalResolver(this.globalResolver);
            InternalFactHandle handle = wm.getFactHandleFactory().newFactHandle(InitialFactImpl.getInstance(), wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, InitialFactImpl.getInstance()), wm, wm);
            wm.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(handle, false, true, null, null));
            ReteooWorkingMemory reteooWorkingMemory = wm;
            return reteooWorkingMemory;
        }
        finally {
            this.ruleBase.readUnlock();
        }
    }

    @Override
    public void addEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.workingMemoryEventSupport.removeEventListener(listener);
    }

    @Override
    public List getWorkingMemoryEventListeners() {
        return this.workingMemoryEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.agendaEventSupport.removeEventListener(listener);
    }

    @Override
    public List getAgendaEventListeners() {
        return this.agendaEventSupport.getEventListeners();
    }

    @Override
    public void addEventListener(RuleBaseEventListener listener) {
        this.ruleBase.addEventListener(listener);
    }

    public List getRuleBaseEventListeners() {
        return this.ruleBase.getRuleBaseEventListeners();
    }

    @Override
    public void removeEventListener(RuleBaseEventListener listener) {
        this.ruleBase.removeEventListener(listener);
    }

    @Override
    public void setAgendaFilter(AgendaFilter agendaFilter) {
        this.agendaFilter = agendaFilter;
    }

    @Override
    public void setGlobal(String identifier, Object value) {
        this.globalResolver.setGlobal(identifier, value);
    }

    @Override
    public void setGlobalResolver(GlobalResolver globalResolver) {
        this.globalResolver = globalResolver;
    }

    @Override
    public void setGlobalExporter(GlobalExporter globalExporter) {
        this.globalExporter = globalExporter;
    }

    @Override
    public void execute(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        wm.insert(object);
        wm.fireAllRules(this.agendaFilter);
    }

    @Override
    public void execute(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            wm.insert(array[i]);
        }
        wm.fireAllRules(this.agendaFilter);
    }

    @Override
    public void execute(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            wm.insert(it.next());
        }
        wm.fireAllRules(this.agendaFilter);
    }

    @Override
    public StatelessSessionResult executeWithResults(Object object) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        wm.insert(object);
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }

    @Override
    public StatelessSessionResult executeWithResults(Object[] array) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            wm.insert(array[i]);
        }
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }

    @Override
    public StatelessSessionResult executeWithResults(Collection collection) {
        InternalWorkingMemory wm = this.newWorkingMemory();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            wm.insert(it.next());
        }
        wm.fireAllRules(this.agendaFilter);
        GlobalResolver globalResolver = null;
        if (this.globalExporter != null) {
            globalResolver = this.globalExporter.export(wm);
        }
        return new ReteStatelessSessionResult(wm, globalResolver);
    }
}

