/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMemory
extends LinkedList<SegmentMemory>
implements LinkedListNode<SegmentMemory> {
    protected static transient Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    private NetworkNode rootNode;
    private NetworkNode tipNode;
    private LinkedList<Memory> nodeMemories;
    private long linkedNodeMask;
    private long allLinkedMaskTest;
    private List<PathMemory> pathMemories;
    private long segmentPosMaskBit;
    private int pos;
    private volatile LeftTupleSets stagedLeftTuples;
    private boolean active;
    private SegmentMemory previous;
    private SegmentMemory next;

    public SegmentMemory(NetworkNode rootNode) {
        this.rootNode = rootNode;
        this.pathMemories = new ArrayList<PathMemory>(1);
        this.nodeMemories = new LinkedList();
        this.stagedLeftTuples = new LeftTupleSets();
    }

    public NetworkNode getRootNode() {
        return this.rootNode;
    }

    public NetworkNode getTipNode() {
        return this.tipNode;
    }

    public void setTipNode(NetworkNode tipNode) {
        this.tipNode = tipNode;
    }

    public LeftTupleSink getSinkFactory() {
        return (LeftTupleSink)this.rootNode;
    }

    public void setSinkFactory(LeftTupleSink sink) {
    }

    public Memory createNodeMemory(MemoryFactory memoryFactory, InternalWorkingMemory wm) {
        Memory memory = wm.getNodeMemory(memoryFactory);
        this.nodeMemories.add(memory);
        return memory;
    }

    public LinkedList<Memory> getNodeMemories() {
        return this.nodeMemories;
    }

    public long getLinkedNodeMask() {
        return this.linkedNodeMask;
    }

    public void setLinkedNodeMask(long linkedNodeMask) {
        this.linkedNodeMask = linkedNodeMask;
    }

    public String getRuleNames() {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.pathMemories.size(); ++i) {
            if (i > 0) {
                sbuilder.append(", ");
            }
            sbuilder.append(this.pathMemories.get(i));
        }
        return sbuilder.toString();
    }

    public void linkNode(long mask, InternalWorkingMemory wm) {
        this.linkedNodeMask |= mask;
        if (log.isTraceEnabled()) {
            log.trace("LinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        this.notifyRuleLinkSegment(wm);
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask |= mask;
        if (log.isTraceEnabled()) {
            log.trace("LinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).linkNodeWithoutRuleNotify(this.segmentPosMaskBit);
            }
        }
    }

    public void notifyRuleLinkSegment(InternalWorkingMemory wm) {
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).linkSegment(this.segmentPosMaskBit, wm);
            }
        }
    }

    public void unlinkNode(long mask, InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            log.trace("UnlinkNode notify=true nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        boolean linked = this.isSegmentLinked();
        this.linkedNodeMask ^= mask;
        if (linked) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                this.pathMemories.get(i).unlinkedSegment(this.segmentPosMaskBit, wm);
            }
        }
    }

    public void unlinkNodeWithoutRuleNotify(long mask) {
        if (log.isTraceEnabled()) {
            log.trace("UnlinkNode notify=false nmask={} smask={} spos={} rules={}", new Object[]{mask, this.linkedNodeMask, this.pos, this.getRuleNames()});
        }
        this.linkedNodeMask ^= mask;
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public boolean isSegmentLinked() {
        return (this.linkedNodeMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public List<PathMemory> getPathMemories() {
        return this.pathMemories;
    }

    public void setPathMemories(List<PathMemory> ruleSegments) {
        this.pathMemories = ruleSegments;
    }

    public long getSegmentPosMaskBit() {
        return this.segmentPosMaskBit;
    }

    public void setSegmentPosMaskBit(long nodeSegmenMask) {
        this.segmentPosMaskBit = nodeSegmenMask;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean evaluating) {
        this.active = evaluating;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public LeftTupleSets getStagedLeftTuples() {
        return this.stagedLeftTuples;
    }

    public void setStagedTuples(LeftTupleSets stagedTuples) {
        this.stagedLeftTuples = stagedTuples;
    }

    @Override
    public SegmentMemory getNext() {
        return this.next;
    }

    @Override
    public void setNext(SegmentMemory next) {
        this.next = next;
    }

    @Override
    public SegmentMemory getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(SegmentMemory previous) {
        this.previous = previous;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * this.rootNode.getId();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentMemory other = (SegmentMemory)obj;
        return !(this.rootNode == null ? other.rootNode != null : this.rootNode.getId() != other.rootNode.getId());
    }
}

