/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Profile;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SettingsAdapter
extends Settings {
    private MavenExecutionRequest request;
    private RuntimeInfo runtimeInfo;

    public SettingsAdapter(MavenExecutionRequest request) {
        this.request = request;
        File userSettings = request.getUserSettingsFile();
        this.runtimeInfo = new RuntimeInfo(userSettings != null && userSettings.isFile() ? userSettings : null);
    }

    @Override
    public String getLocalRepository() {
        if (this.request.getLocalRepositoryPath() != null) {
            return this.request.getLocalRepositoryPath().getAbsolutePath();
        }
        return null;
    }

    @Override
    public boolean isInteractiveMode() {
        return this.request.isInteractiveMode();
    }

    @Override
    public boolean isOffline() {
        return this.request.isOffline();
    }

    @Override
    public List<Proxy> getProxies() {
        return this.request.getProxies();
    }

    @Override
    public List<Server> getServers() {
        return this.request.getServers();
    }

    @Override
    public List<Mirror> getMirrors() {
        return this.request.getMirrors();
    }

    @Override
    public List<org.apache.maven.settings.Profile> getProfiles() {
        ArrayList<org.apache.maven.settings.Profile> result = new ArrayList<org.apache.maven.settings.Profile>();
        for (Profile profile : this.request.getProfiles()) {
            result.add(SettingsUtils.convertToSettingsProfile(profile));
        }
        return result;
    }

    @Override
    public List<String> getActiveProfiles() {
        return this.request.getActiveProfiles();
    }

    @Override
    public List<String> getPluginGroups() {
        return this.request.getPluginGroups();
    }

    @Override
    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }
}

