/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return type.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValue = this.fromExpression(configuration, expressionEvaluator);
        if (retValue != null) {
            if (retValue instanceof Collection) {
                retValue = this.toArray(type, (Collection)retValue);
            } else if (retValue instanceof String && (!retValue.equals(configuration.getValue()) || "".equals(retValue))) {
                PlexusConfiguration syntheticConfiguration = this.toConfiguration(configuration.getName(), (String)retValue);
                retValue = this.fromChildren(converterLookup, syntheticConfiguration, type, baseType, classLoader, expressionEvaluator, listener);
            } else {
                this.failIfNotTypeCompatible(retValue, type, configuration);
            }
        } else {
            retValue = this.fromChildren(converterLookup, configuration, type, baseType, classLoader, expressionEvaluator, listener);
        }
        return retValue;
    }

    private PlexusConfiguration toConfiguration(String name, String value) {
        String[] tokens;
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(name);
        for (String token : tokens = value != null && value.length() > 0 ? value.split(",", -1) : new String[]{}) {
            configuration.addChild("#", token);
        }
        return configuration;
    }

    private Object fromChildren(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < configuration.getChildCount(); ++i) {
            PlexusConfiguration childConfiguration = configuration.getChild(i);
            Class<?> childType = this.getChildType(childConfiguration, type, baseType, classLoader);
            ConfigurationConverter converter = converterLookup.lookupConverterForType(childType);
            Object object = converter.fromConfiguration(converterLookup, childConfiguration, childType, baseType, classLoader, expressionEvaluator, listener);
            values.add(object);
        }
        return this.toArray(type, values);
    }

    private Class<?> getChildType(PlexusConfiguration childConfiguration, Class<?> arrayType, Class<?> baseType, ClassLoader classLoader) throws ComponentConfigurationException {
        String configEntry = childConfiguration.getName();
        String name = this.fromXML(configEntry);
        Class<?> childType = this.getClassForImplementationHint(null, childConfiguration, classLoader);
        if (childType == null && name.indexOf(46) > 0) {
            try {
                childType = classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (childType == null) {
            String className;
            String baseTypeName = baseType.getName();
            int lastDot = baseTypeName.lastIndexOf(46);
            if (lastDot == -1) {
                className = name;
            } else {
                String basePackage = baseTypeName.substring(0, lastDot);
                className = basePackage + "." + StringUtils.capitalizeFirstLetter(name);
            }
            try {
                childType = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (childType == null) {
            childType = arrayType.getComponentType();
        }
        return childType;
    }

    private Object toArray(Class<?> type, Collection<?> values) throws ComponentConfigurationException {
        try {
            return values.toArray((Object[])Array.newInstance(type.getComponentType(), values.size()));
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException("Cannot assign configuration values to array of type " + type.getComponentType().getName() + ": " + values);
        }
    }
}

