/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationUtils;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.TypeDeclarationError;
import org.drools.compiler.lang.descr.AbstractClassTypeDeclarationDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.util.StringUtils;
import org.drools.core.util.asm.ClassFieldInspector;
import org.kie.api.definition.type.FactField;

public class TypeDeclarationFactory {
    protected KnowledgeBuilderImpl kbuilder;

    public TypeDeclarationFactory(KnowledgeBuilderImpl kbuilder) {
        this.kbuilder = kbuilder;
    }

    public TypeDeclaration processTypeDeclaration(PackageRegistry pkgRegistry, AbstractClassTypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes, Map<String, AbstractClassTypeDeclarationDescr> unprocessableDescrs) {
        TypeDeclaration type = this.createTypeDeclaration(typeDescr, unresolvedTypes);
        TypeDeclaration parent = this.getParentDeclaration(typeDescr, unresolvedTypes);
        this.processTypeAnnotations(typeDescr, type, parent);
        type.setNovel(TypeDeclarationUtils.isNovelClass(typeDescr, pkgRegistry));
        type.setNature(type.isNovel() ? TypeDeclaration.Nature.DEFINITION : TypeDeclaration.Nature.DECLARATION);
        return type;
    }

    protected TypeDeclaration createTypeDeclaration(AbstractClassTypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes) {
        TypeDeclaration type = new TypeDeclaration(typeDescr.getTypeName());
        type.setResource(typeDescr.getResource());
        return type;
    }

    protected TypeDeclaration getParentDeclaration(AbstractClassTypeDeclarationDescr typeDescr, List<TypeDefinition> unresolvedTypes) {
        PackageRegistry sup;
        TypeDeclaration parent = null;
        if (!typeDescr.getSuperTypes().isEmpty() && (sup = this.kbuilder.getPackageRegistry(typeDescr.getSuperTypeNamespace())) != null) {
            parent = sup.getPackage().getTypeDeclaration(typeDescr.getSuperTypeName());
            if (parent == null) {
                // empty if block
            }
            if (parent != null && parent.getNature() == TypeDeclaration.Nature.DECLARATION && this.kbuilder.getKnowledgeBase() != null) {
                parent = ((InternalKnowledgePackage)this.kbuilder.getKnowledgeBase().getPackagesMap().get(typeDescr.getSuperTypeNamespace())).getTypeDeclaration(typeDescr.getSuperTypeName());
            }
        }
        return parent;
    }

    protected void processTypeAnnotations(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, TypeDeclaration parent) {
        String className;
        String kind;
        String format;
        String typesafe;
        String role;
        AnnotationDescr annotationDescr = this.getSingleAnnotation(typeDescr, "role");
        String string = role = annotationDescr != null ? annotationDescr.getSingleValue() : null;
        if (role != null) {
            type.setRole(TypeDeclaration.Role.parseRole((String)role));
        }
        String string2 = typesafe = (annotationDescr = this.getSingleAnnotation(typeDescr, "typesafe")) != null ? annotationDescr.getSingleValue() : null;
        if (typesafe != null) {
            type.setTypesafe(Boolean.parseBoolean(typesafe));
        }
        String string3 = format = (annotationDescr = this.getSingleAnnotation(typeDescr, "format")) != null ? annotationDescr.getSingleValue() : null;
        if (format != null) {
            type.setFormat(TypeDeclaration.Format.parseFormat((String)format));
        }
        String string4 = kind = (annotationDescr = this.getSingleAnnotation(typeDescr, "kind")) != null ? annotationDescr.getSingleValue() : null;
        if (kind != null) {
            type.setKind(TypeDeclaration.Kind.parseKind((String)kind));
        }
        if (typeDescr instanceof EnumDeclarationDescr) {
            type.setKind(TypeDeclaration.Kind.ENUM);
        }
        String string5 = className = (annotationDescr = this.getSingleAnnotation(typeDescr, "class")) != null ? annotationDescr.getSingleValue() : null;
        if (StringUtils.isEmpty((CharSequence)className)) {
            className = type.getTypeName();
        }
        type.setDynamic((annotationDescr = this.getSingleAnnotation(typeDescr, "propertyChangeSupport")) != null);
    }

    protected AnnotationDescr getSingleAnnotation(AbstractClassTypeDeclarationDescr typeDescr, String name) {
        AnnotationDescr annotationDescr = typeDescr.getAnnotation(name);
        if (annotationDescr != null && annotationDescr.isDuplicated()) {
            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Duplicated annotation '" + name + "' for type declaration of '" + typeDescr.getTypeName() + "'"));
            return null;
        }
        return annotationDescr;
    }

    protected void checkRedeclaration(AbstractClassTypeDeclarationDescr typeDescr, TypeDeclaration type, PackageRegistry pkgRegistry) {
        block14: {
            TypeDeclaration previousTypeDeclaration = this.kbuilder.getPackageRegistry(typeDescr.getNamespace()).getPackage().getTypeDeclaration(typeDescr.getTypeName());
            try {
                if (previousTypeDeclaration == null) {
                    Class<?> existingDeclarationClass = TypeDeclarationUtils.getExistingDeclarationClass(typeDescr, pkgRegistry);
                    if (this.kbuilder.getBuilderConfiguration().isPreCompiled() || GeneratedFact.class.isAssignableFrom(existingDeclarationClass) || type.getTypeClassDef().getFields().isEmpty()) break block14;
                    try {
                        Class existingClass = pkgRegistry.getPackage().getTypeResolver().resolveType(typeDescr.getType().getFullName());
                        ClassFieldInspector cfi = new ClassFieldInspector(existingClass);
                        int fieldCount = 0;
                        for (String existingFieldName : cfi.getFieldTypesField().keySet()) {
                            if (cfi.isNonGetter(existingFieldName) || "class".equals(existingFieldName) || !cfi.getSetterMethods().containsKey(existingFieldName)) continue;
                            if (!typeDescr.getFields().containsKey(existingFieldName)) {
                                type.setValid(false);
                                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " does not include field " + existingFieldName));
                                continue;
                            }
                            String fldType = ((Class)cfi.getFieldTypes().get(existingFieldName)).getName();
                            fldType = TypeDeclarationUtils.toBuildableType(fldType, this.kbuilder.getRootClassLoader());
                            TypeFieldDescr declaredField = typeDescr.getFields().get(existingFieldName);
                            if (!fldType.equals(type.getTypeClassDef().getField(existingFieldName).getTypeName())) {
                                type.setValid(false);
                                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " redeclared field " + existingFieldName + " : \n" + "existing : " + fldType + " vs declared : " + declaredField.getPattern().getObjectType()));
                                continue;
                            }
                            ++fieldCount;
                        }
                        if (fieldCount != typeDescr.getFields().size()) {
                            this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "New declaration of " + typeDescr.getType().getFullName() + " can't declaredeclares a different set of fields \n" + "existing : " + cfi.getFieldTypesField() + "\n" + "declared : " + typeDescr.getFields()));
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        type.setValid(false);
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to redeclare " + typeDescr.getType().getFullName() + " : " + e.getMessage()));
                    }
                    catch (ClassNotFoundException e) {
                        type.setValid(false);
                        this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, "Unable to redeclare " + typeDescr.getType().getFullName() + " : " + e.getMessage()));
                    }
                    break block14;
                }
                int typeComparisonResult = this.compareTypeDeclarations(previousTypeDeclaration, type);
                if (typeComparisonResult < 0) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, typeDescr.getType().getFullName() + " declares more fields than the already existing version"));
                    type.setValid(false);
                } else if (typeComparisonResult > 0 && !type.getTypeClassDef().getFields().isEmpty()) {
                    this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, typeDescr.getType().getFullName() + " declares less fields than the already existing version"));
                    type.setValid(false);
                }
                if (type.getNature() == TypeDeclaration.Nature.DECLARATION) {
                    this.mergeTypeDeclarations(previousTypeDeclaration, type);
                }
            }
            catch (IncompatibleClassChangeError error) {
                this.kbuilder.addBuilderResult(new TypeDeclarationError(typeDescr, error.getMessage()));
            }
        }
    }

    protected void mergeTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) {
        if (oldDeclaration == null) {
            return;
        }
        for (FieldDefinition oldFactField : oldDeclaration.getTypeClassDef().getFieldsDefinitions()) {
            FieldDefinition newFactField = newDeclaration.getTypeClassDef().getField(oldFactField.getName());
            if (newFactField != null) continue;
            newDeclaration.getTypeClassDef().addField(oldFactField);
        }
        newDeclaration.setTypeClass(oldDeclaration.getTypeClass());
    }

    protected int compareTypeDeclarations(TypeDeclaration oldDeclaration, TypeDeclaration newDeclaration) throws IncompatibleClassChangeError {
        if (!oldDeclaration.getFormat().equals((Object)newDeclaration.getFormat())) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " format that its previous definition: " + newDeclaration.getFormat() + "!=" + oldDeclaration.getFormat());
        }
        if (!(oldDeclaration.getTypeClassDef().getSuperClass().equals(newDeclaration.getTypeClassDef().getSuperClass()) || oldDeclaration.getNature() == TypeDeclaration.Nature.DEFINITION && newDeclaration.getNature() == TypeDeclaration.Nature.DECLARATION && Object.class.getName().equals(newDeclaration.getTypeClassDef().getSuperClass()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " superclass that its previous definition: " + newDeclaration.getTypeClassDef().getSuperClass() + " != " + oldDeclaration.getTypeClassDef().getSuperClass());
        }
        if (!this.nullSafeEqualityComparison((Comparable)((Object)oldDeclaration.getDurationAttribute()), (Comparable)((Object)newDeclaration.getDurationAttribute()))) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " has a different" + " duration: " + newDeclaration.getDurationAttribute() + " != " + oldDeclaration.getDurationAttribute());
        }
        if (newDeclaration.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && oldDeclaration.getSetMask() != newDeclaration.getSetMask()) {
            throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + " is incompatible with" + " the previous definition: " + newDeclaration + " != " + oldDeclaration);
        }
        List oldFields = oldDeclaration.getTypeClassDef().getFields();
        HashMap<String, FactField> newFieldsMap = new HashMap<String, FactField>();
        for (FactField factField : newDeclaration.getTypeClassDef().getFields()) {
            newFieldsMap.put(factField.getName(), factField);
        }
        boolean allFieldsInOldDeclarationAreStillPresent = true;
        for (FactField oldFactField : oldFields) {
            FactField newFactField = (FactField)newFieldsMap.get(oldFactField.getName());
            if (newFactField != null) {
                String newFactType = ((FieldDefinition)newFactField).getTypeName();
                if (newFactType.equals(((FieldDefinition)oldFactField).getTypeName())) continue;
                throw new IncompatibleClassChangeError("Type Declaration " + newDeclaration.getTypeName() + "." + newFactField.getName() + " has a different" + " type that its previous definition: " + newFactType + " != " + oldFactField.getType().getCanonicalName());
            }
            allFieldsInOldDeclarationAreStillPresent = false;
        }
        if (oldFields.size() < newFieldsMap.size()) {
            return -1;
        }
        if (oldFields.size() > newFieldsMap.size()) {
            return 1;
        }
        if (allFieldsInOldDeclarationAreStillPresent) {
            return 0;
        }
        throw new IncompatibleClassChangeError(newDeclaration.getTypeName() + " introduces" + " fields that are not present in its previous version.");
    }

    protected boolean nullSafeEqualityComparison(Comparable c1, Comparable c2) {
        if (c1 == null) {
            return c2 == null;
        }
        return c2 != null && c1.compareTo(c2) == 0;
    }
}

