/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassBuilderFactory;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.MapCore;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.LogicalMapCore;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitCoreWrapperClassBuilderImpl;
import org.drools.core.factmodel.traits.TraitMapPropertyWrapperClassBuilderImpl;
import org.drools.core.factmodel.traits.TraitMapProxyClassBuilderImpl;
import org.drools.core.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.core.factmodel.traits.TraitProxyClassBuilder;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitTriplePropertyWrapperClassBuilderImpl;
import org.drools.core.factmodel.traits.TraitTripleProxyClassBuilderImpl;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.factmodel.traits.VirtualPropertyMode;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleStore;
import org.drools.core.util.asm.ClassFieldInspector;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;

public abstract class AbstractTraitFactory<T extends Thing<K>, K extends TraitableBean>
implements Opcodes,
Externalizable {
    protected VirtualPropertyMode mode = VirtualPropertyMode.TRIPLES;
    public static final String SUFFIX = "_Trait__Extension";
    protected static final String pack = "org.drools.core.factmodel.traits.";
    protected Map<String, Constructor> factoryCache = new HashMap<String, Constructor>();
    protected Map<Class, Class<? extends CoreWrapper<?>>> wrapperCache = new HashMap();

    protected static void setMode(VirtualPropertyMode newMode, KieComponentFactory rcf) {
        ClassBuilderFactory cbf = rcf.getClassBuilderFactory();
        rcf.getTraitFactory().mode = newMode;
        switch (newMode) {
            case MAP: {
                cbf.setPropertyWrapperBuilder(new TraitMapPropertyWrapperClassBuilderImpl());
                cbf.setTraitProxyBuilder(new TraitMapProxyClassBuilderImpl());
                break;
            }
            case TRIPLES: {
                cbf.setPropertyWrapperBuilder(new TraitTriplePropertyWrapperClassBuilderImpl());
                cbf.setTraitProxyBuilder(new TraitTripleProxyClassBuilderImpl());
                break;
            }
            default: {
                throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)newMode));
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.mode);
        out.writeObject(this.factoryCache);
        out.writeObject(this.wrapperCache);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mode = (VirtualPropertyMode)((Object)in.readObject());
        this.factoryCache = (Map)in.readObject();
        this.wrapperCache = (Map)in.readObject();
    }

    @Deprecated
    public T getProxy(K core, Class<?> trait) throws LogicalTypeInconsistencyException {
        return this.getProxy(core, trait, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getProxy(K core, Class<?> trait, boolean logical) throws LogicalTypeInconsistencyException {
        Constructor<T> konst;
        String traitName = trait.getName();
        if (core.hasTrait(traitName)) {
            return (T)core.getTrait(traitName);
        }
        String key = AbstractTraitFactory.getKey(core.getClass(), trait);
        Map<String, Constructor> map = this.factoryCache;
        synchronized (map) {
            konst = this.factoryCache.get(key);
            if (konst == null) {
                konst = this.cacheConstructor(key, core, trait);
            }
        }
        Thing proxy = null;
        HierarchyEncoder hier = this.getHierarchyEncoder();
        try {
            switch (this.mode) {
                case MAP: {
                    proxy = (Thing)konst.newInstance(core, core._getDynamicProperties(), hier.getCode(trait.getName()), hier.getBottom(), logical);
                    break;
                }
                case TRIPLES: {
                    proxy = (Thing)konst.newInstance(core, this.getTripleStore(), this.getTripleFactory(), hier.getCode(trait.getName()), hier.getBottom(), logical);
                    break;
                }
                default: {
                    throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)this.mode));
                }
            }
            return (T)proxy;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        throw new LogicalTypeInconsistencyException("Could not apply trait " + trait + " to object " + core, trait, core.getClass());
    }

    protected Constructor<T> cacheConstructor(String key, K core, Class<?> trait) {
        Class<T> proxyClass = this.buildProxyClass(key, core, trait);
        if (proxyClass == null) {
            return null;
        }
        try {
            Constructor<T> konst;
            switch (this.mode) {
                case MAP: {
                    konst = proxyClass.getConstructor(core.getClass(), Map.class, BitSet.class, BitSet.class, Boolean.TYPE);
                    break;
                }
                case TRIPLES: {
                    konst = proxyClass.getConstructor(core.getClass(), TripleStore.class, TripleFactory.class, BitSet.class, BitSet.class, Boolean.TYPE);
                    break;
                }
                default: {
                    throw new RuntimeException(" This should not happen : unexpected property wrapping method " + (Object)((Object)this.mode));
                }
            }
            this.factoryCache.put(key, konst);
            return konst;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getProxyName(ClassDefinition trait, ClassDefinition core) {
        return AbstractTraitFactory.getKey(core.getDefinedClass(), trait.getDefinedClass()) + "_Proxy";
    }

    public static String getPropertyWrapperName(ClassDefinition trait, ClassDefinition core) {
        return AbstractTraitFactory.getKey(core.getDefinedClass(), trait.getDefinedClass()) + "_ProxyWrapper";
    }

    protected static String getKey(Class core, Class trait) {
        return trait.getName() + "." + core.getName();
    }

    public static String getSoftFieldKey(String fieldName, Class fieldType, Class trait, Class core) {
        return fieldName;
    }

    protected Class<T> buildProxyClass(String key, K core, Class<?> trait) {
        Class<?> coreKlass = core.getClass();
        ClassDefinition tdef = this.getTraitRegistry().getTrait(trait.getName());
        ClassDefinition cdef = this.getTraitRegistry().getTraitable(coreKlass.getName());
        if (tdef == null) {
            if (trait.getAnnotation(Trait.class) != null) {
                try {
                    if (!Thing.class.isAssignableFrom(trait)) {
                        throw new RuntimeException("Unable to create definition for class " + trait + " : trait interfaces should extend " + Thing.class.getName() + " or be DECLARED as traits explicitly");
                    }
                    tdef = this.buildClassDefinition(trait, null);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to create definition for class " + trait + " : " + e.getMessage());
                }
                this.getTraitRegistry().addTrait(tdef);
            } else {
                throw new RuntimeException("Unable to find Trait definition for class " + trait.getName() + ". It should have been DECLARED as a trait");
            }
        }
        if (cdef == null) {
            if (core.getClass().getAnnotation(Traitable.class) != null) {
                try {
                    cdef = this.buildClassDefinition(core.getClass(), core.getClass());
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to create definition for class " + coreKlass.getName() + " : " + e.getMessage());
                }
                this.getTraitRegistry().addTraitable(cdef);
            } else {
                throw new RuntimeException("Unable to find Core class definition for class " + coreKlass.getName() + ". It should have been DECLARED as a trait");
            }
        }
        String proxyName = AbstractTraitFactory.getProxyName(tdef, cdef);
        String wrapperName = AbstractTraitFactory.getPropertyWrapperName(tdef, cdef);
        KieComponentFactory rcf = this.getComponentFactory();
        TraitPropertyWrapperClassBuilder propWrapperBuilder = (TraitPropertyWrapperClassBuilder)rcf.getClassBuilderFactory().getPropertyWrapperBuilder();
        propWrapperBuilder.init(tdef, this.getTraitRegistry());
        try {
            byte[] propWrapper = propWrapperBuilder.buildClass(cdef, this.getRootClassLoader());
            this.registerAndLoadTypeDefinition(wrapperName, propWrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TraitProxyClassBuilder proxyBuilder = (TraitProxyClassBuilder)rcf.getClassBuilderFactory().getTraitProxyBuilder();
        proxyBuilder.init(tdef, rcf.getBaseTraitProxyClass(), this.getTraitRegistry());
        try {
            byte[] proxy = proxyBuilder.buildClass(cdef, this.getRootClassLoader());
            this.registerAndLoadTypeDefinition(proxyName, proxy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            BitSet mask = this.getTraitRegistry().getFieldMask(trait.getName(), cdef.getDefinedClass().getName());
            Class<?> wrapperClass = this.getRootClassLoader().loadClass(wrapperName);
            Class<?> proxyClass = this.getRootClassLoader().loadClass(proxyName);
            return proxyClass;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized <K> CoreWrapper<K> getCoreWrapper(Class<K> coreKlazz, ClassDefinition coreDef) {
        if (this.wrapperCache == null) {
            this.wrapperCache = new HashMap();
        }
        Class<CoreWrapper<Object>> wrapperClass = null;
        if (this.wrapperCache.containsKey(coreKlazz)) {
            wrapperClass = this.wrapperCache.get(coreKlazz);
        } else {
            try {
                wrapperClass = this.buildCoreWrapper(coreKlazz, coreDef);
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            this.wrapperCache.put(coreKlazz, wrapperClass);
        }
        try {
            this.getTraitRegistry().addTraitable(this.buildClassDefinition(coreKlazz, wrapperClass));
            return wrapperClass != null ? wrapperClass.newInstance() : null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public <K> TraitableBean<K, CoreWrapper<K>> asTraitable(K core, ClassDefinition coreDef) {
        if (coreDef.getDefinedClass() != core.getClass()) {
            try {
                coreDef = this.buildClassDefinition(core.getClass(), core.getClass());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (core instanceof Map) {
            if (!coreDef.isTraitable()) {
                throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass() + ". Was it declared as @Traitable? ");
            }
            return coreDef.isFullTraiting() ? new LogicalMapCore((Map)core) : new MapCore((Map)core);
        }
        CoreWrapper<?> wrapper = this.getCoreWrapper(core.getClass(), coreDef);
        if (wrapper == null) {
            throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass() + ". Was it declared as @Traitable? ");
        }
        wrapper.init(core);
        return wrapper;
    }

    public ClassDefinition buildClassDefinition(Class<?> klazz, Class<?> wrapperClass) throws IOException {
        ClassDefinition def;
        ClassFieldInspector inspector = new ClassFieldInspector(klazz);
        ClassFieldAccessorStore store = this.getClassFieldAccessorStore();
        if (!klazz.isInterface()) {
            String className = wrapperClass.getName();
            String superClass = wrapperClass != klazz ? klazz.getName() : klazz.getSuperclass().getName();
            String[] interfaces = new String[klazz.getInterfaces().length + 1];
            for (int j = 0; j < klazz.getInterfaces().length; ++j) {
                interfaces[j] = klazz.getInterfaces()[j].getName();
            }
            interfaces[interfaces.length - 1] = CoreWrapper.class.getName();
            def = new ClassDefinition(className, superClass, interfaces);
            def.setDefinedClass(wrapperClass);
            Traitable tbl = wrapperClass.getAnnotation(Traitable.class);
            def.setTraitable(true, tbl != null && tbl.logical());
            Map<String, Field> fields = inspector.getFieldTypesField();
            for (Field f : fields.values()) {
                if (f == null) continue;
                FieldDefinition fld = new FieldDefinition();
                fld.setName(f.getName());
                fld.setTypeName(f.getType().getName());
                fld.setInherited(true);
                ClassFieldAccessor accessor = store.getAccessor(def.getDefinedClass().getName(), fld.getName());
                fld.setReadWriteAccessor(accessor);
                def.addField(fld);
            }
        } else {
            String className = klazz.getName();
            String superClass = Object.class.getName();
            String[] interfaces = new String[klazz.getInterfaces().length];
            for (int j = 0; j < klazz.getInterfaces().length; ++j) {
                interfaces[j] = klazz.getInterfaces()[j].getName();
            }
            def = new ClassDefinition(className, superClass, interfaces);
            def.setDefinedClass(klazz);
            Map<String, Method> properties = inspector.getGetterMethods();
            for (Method m : properties.values()) {
                if (m == null || m.getDeclaringClass() == TraitType.class || m.getDeclaringClass() == Thing.class) continue;
                FieldDefinition fld = new FieldDefinition();
                fld.setName(this.getterToFieldName(m.getName()));
                fld.setTypeName(m.getReturnType().getName());
                fld.setInherited(true);
                ClassFieldAccessor accessor = store.getAccessor(def.getDefinedClass().getName(), fld.getName());
                fld.setReadWriteAccessor(accessor);
                def.addField(fld);
            }
        }
        return def;
    }

    private String getterToFieldName(String getter) {
        getter = getter.startsWith("is") ? getter.substring(2) : getter.substring(3);
        getter = getter.substring(0, 1).toLowerCase() + getter.substring(1);
        return getter;
    }

    protected <K> Class<CoreWrapper<K>> buildCoreWrapper(Class<K> coreKlazz, ClassDefinition coreDef) throws IOException, ClassNotFoundException {
        String coreName = coreKlazz.getName();
        String wrapperName = coreName + "Wrapper";
        try {
            byte[] wrapper = new TraitCoreWrapperClassBuilderImpl().buildClass(coreDef, this.getRootClassLoader());
            this.registerAndLoadTypeDefinition(wrapperName, wrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class<CoreWrapper<K>> wrapperClass = this.getRootClassLoader().loadClass(wrapperName);
        return wrapperClass;
    }

    public static void valueOf(MethodVisitor mv, String type) {
        mv.visitMethodInsn(184, BuildUtils.getInternalType(BuildUtils.box(type)), "valueOf", "(" + BuildUtils.getTypeDescriptor(type) + ")" + BuildUtils.getTypeDescriptor(BuildUtils.box(type)));
    }

    public static void primitiveValue(MethodVisitor mv, String fieldType) {
        mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fieldType)));
        mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fieldType)), fieldType + "Value", "()" + BuildUtils.getTypeDescriptor(fieldType));
    }

    public static void invokeExtractor(MethodVisitor mv, String masterName, ClassDefinition trait, ClassDefinition core, FieldDefinition field) {
        FieldDefinition tgtField = core.getFieldByAlias(field.resolveAlias());
        String fieldType = tgtField.getTypeName();
        String fieldName = tgtField.getName();
        String returnType = BuildUtils.getTypeDescriptor(fieldType);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", BuildUtils.getTypeDescriptor(core.getClassName()));
        mv.visitMethodInsn(182, Type.getInternalName(core.getDefinedClass()), BuildUtils.getterName(fieldName, fieldType), Type.getMethodDescriptor((Type)Type.getType((String)returnType), (Type[])new Type[0]));
    }

    public static void invokeInjector(MethodVisitor mv, String masterName, ClassDefinition trait, ClassDefinition core, FieldDefinition field, boolean toNull, int pointer) {
        FieldDefinition tgtField = core.getFieldByAlias(field.resolveAlias());
        String fieldType = tgtField.getTypeName();
        String fieldName = tgtField.getName();
        String returnType = BuildUtils.getTypeDescriptor(fieldType);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", BuildUtils.getTypeDescriptor(core.getName()));
        if (toNull) {
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
        } else {
            mv.visitVarInsn(BuildUtils.varType(fieldType), pointer);
        }
        if (!BuildUtils.isPrimitive(fieldType)) {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(fieldType));
        }
        mv.visitMethodInsn(182, Type.getInternalName(core.getDefinedClass()), BuildUtils.setterName(fieldName, fieldType), Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType((String)returnType)}));
    }

    public static String buildSignature(Method method) {
        String sig = "(";
        for (Class<?> arg : method.getParameterTypes()) {
            sig = sig + BuildUtils.getTypeDescriptor(arg.getName());
        }
        sig = sig + ")";
        sig = sig + BuildUtils.getTypeDescriptor(method.getReturnType().getName());
        return sig;
    }

    public static int getStackSize(Method m) {
        int stack = 1;
        for (Class<?> klass : m.getParameterTypes()) {
            stack += BuildUtils.sizeOf(klass.getName());
        }
        return stack;
    }

    protected abstract Class<?> registerAndLoadTypeDefinition(String var1, byte[] var2) throws ClassNotFoundException;

    protected abstract ClassLoader getRootClassLoader();

    protected abstract KieComponentFactory getComponentFactory();

    protected abstract TraitRegistry getTraitRegistry();

    protected abstract HierarchyEncoder getHierarchyEncoder();

    protected abstract TripleStore getTripleStore();

    protected abstract TripleFactory getTripleFactory();

    protected abstract ClassFieldAccessorStore getClassFieldAccessorStore();
}

