/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.MediumCharMatcher;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;

@Beta
@GwtCompatible
public abstract class CharMatcher
implements Predicate<Character> {
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).withToString("CharMatcher.BREAKING_WHITESPACE").precomputed();
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f', "CharMatcher.ASCII");
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;
    final String description;
    public static final CharMatcher WHITESPACE;

    public static CharMatcher is(final char match) {
        String description = "CharMatcher.is(" + Integer.toHexString(match) + ")";
        return new CharMatcher(description){

            @Override
            public boolean matches(char c) {
                return c == match;
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString().replace(match, replacement);
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? this : NONE;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? other : super.or(other);
            }

            @Override
            public CharMatcher negate() {
                return 8.isNot(match);
            }

            @Override
            void setBits(LookupTable table) {
                table.set(match);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher isNot(final char match) {
        String description = "CharMatcher.isNot(" + Integer.toHexString(match) + ")";
        return new CharMatcher(description){

            @Override
            public boolean matches(char c) {
                return c != match;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? super.and(other) : other;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? ANY : this;
            }

            @Override
            public CharMatcher negate() {
                return 9.is(match);
            }
        };
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                final char match1 = sequence.charAt(0);
                final char match2 = sequence.charAt(1);
                return new CharMatcher("CharMatcher.anyOf(\"" + sequence + "\")"){

                    @Override
                    public boolean matches(char c) {
                        return c == match1 || c == match2;
                    }

                    @Override
                    void setBits(LookupTable table) {
                        table.set(match1);
                        table.set(match2);
                    }

                    @Override
                    public CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        final char[] chars = ((Object)sequence).toString().toCharArray();
        Arrays.sort(chars);
        return new CharMatcher("CharMatcher.anyOf(\"" + chars + "\")"){

            @Override
            public boolean matches(char c) {
                return Arrays.binarySearch(chars, c) >= 0;
            }
        };
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf(sequence).negate();
    }

    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        Preconditions.checkArgument(endInclusive >= startInclusive);
        String description = "CharMatcher.inRange(" + Integer.toHexString(startInclusive) + ", " + Integer.toHexString(endInclusive) + ")";
        return CharMatcher.inRange(startInclusive, endInclusive, description);
    }

    static CharMatcher inRange(final char startInclusive, final char endInclusive, String description) {
        return new CharMatcher(description){

            @Override
            public boolean matches(char c) {
                return startInclusive <= c && c <= endInclusive;
            }

            @Override
            void setBits(LookupTable table) {
                char c;
                char c2 = startInclusive;
                do {
                    table.set(c2);
                    c = c2;
                    c2 = (char)(c2 + '\u0001');
                } while (c != endInclusive);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher forPredicate(final Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        String description = "CharMatcher.forPredicate(" + predicate + ')';
        return new CharMatcher(description){

            @Override
            public boolean matches(char c) {
                return predicate.apply(Character.valueOf(c));
            }

            @Override
            public boolean apply(Character character) {
                return predicate.apply(Preconditions.checkNotNull(character));
            }
        };
    }

    CharMatcher(String description) {
        this.description = description;
    }

    protected CharMatcher() {
        this.description = "UnknownCharMatcher";
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        final CharMatcher original = this;
        return new CharMatcher(original + ".negate()"){

            @Override
            public boolean matches(char c) {
                return !original.matches(c);
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return original.matchesNoneOf(sequence);
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return original.matchesAllOf(sequence);
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length() - original.countIn(sequence);
            }

            @Override
            public CharMatcher negate() {
                return original;
            }
        };
    }

    public CharMatcher and(CharMatcher other) {
        return new And(this, Preconditions.checkNotNull(other));
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(this, Preconditions.checkNotNull(other));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    char[] slowGetChars() {
        char[] allChars = new char[65536];
        int size = 0;
        for (int c = 0; c <= 65535; ++c) {
            if (!this.matches((char)c)) continue;
            allChars[size++] = (char)c;
        }
        char[] retValue = new char[size];
        System.arraycopy(allChars, 0, retValue, 0, size);
        return retValue;
    }

    CharMatcher precomputedInternal() {
        char[] chars = this.slowGetChars();
        int totalCharacters = chars.length;
        if (totalCharacters == 0) {
            return NONE;
        }
        if (totalCharacters == 1) {
            return CharMatcher.is(chars[0]);
        }
        if (totalCharacters < 63) {
            return SmallCharMatcher.from(chars, this.toString());
        }
        if (totalCharacters < 1023) {
            return MediumCharMatcher.from(chars, this.toString());
        }
        final LookupTable table = new LookupTable();
        this.setBits(table);
        CharMatcher outer = this;
        return new CharMatcher(outer.toString()){

            @Override
            public boolean matches(char c) {
                return table.get(c);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    CharMatcher withToString(String description) {
        throw new UnsupportedOperationException();
    }

    void setBits(LookupTable table) {
        char c;
        char c2 = '\u0000';
        do {
            if (this.matches(c2)) {
                table.set(c2);
            }
            c = c2;
            c2 = (char)(c2 + '\u0001');
        } while (c != 65535);
    }

    public boolean matchesAnyOf(CharSequence sequence) {
        return !this.matchesNoneOf(sequence);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (this.matches(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence) {
        return this.indexIn(sequence) == -1;
    }

    public int indexIn(CharSequence sequence) {
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        for (int i = start; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    @CheckReturnValue
    public String removeFrom(CharSequence sequence) {
        String string = ((Object)sequence).toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        block0: while (true) {
            ++pos;
            while (pos != chars.length) {
                if (!this.matches(chars[pos])) {
                    chars[pos - spread] = chars[pos];
                    ++pos;
                    continue;
                }
                ++spread;
                continue block0;
            }
            break;
        }
        return new String(chars, 0, pos - spread);
    }

    @CheckReturnValue
    public String retainFrom(CharSequence sequence) {
        return this.negate().removeFrom(sequence);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = ((Object)sequence).toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[pos] = replacement;
        for (int i = pos + 1; i < chars.length; ++i) {
            if (!this.matches(chars[i])) continue;
            chars[i] = replacement;
        }
        return new String(chars);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = ((Object)sequence).toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder buf = new StringBuilder(len * 3 / 2 + 16);
        int oldpos = 0;
        do {
            buf.append(string, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn(string, oldpos = pos + 1)) != -1);
        buf.append(string, oldpos, len);
        return buf.toString();
    }

    @CheckReturnValue
    public String trimFrom(CharSequence sequence) {
        int last;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return ((Object)sequence.subSequence(first, last + 1)).toString();
    }

    @CheckReturnValue
    public String trimLeadingFrom(CharSequence sequence) {
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        return ((Object)sequence.subSequence(first, len)).toString();
    }

    @CheckReturnValue
    public String trimTrailingFrom(CharSequence sequence) {
        int last;
        int len = sequence.length();
        for (last = len - 1; last >= 0 && this.matches(sequence.charAt(last)); --last) {
        }
        return ((Object)sequence.subSequence(0, last + 1)).toString();
    }

    @CheckReturnValue
    public String collapseFrom(CharSequence sequence, char replacement) {
        int first = this.indexIn(sequence);
        if (first == -1) {
            return ((Object)sequence).toString();
        }
        StringBuilder builder = new StringBuilder(sequence.length()).append(sequence.subSequence(0, first)).append(replacement);
        boolean in = true;
        for (int i = first + 1; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (this.matches(c)) {
                if (in) continue;
                builder.append(replacement);
                in = true;
                continue;
            }
            builder.append(c);
            in = false;
        }
        return builder.toString();
    }

    @CheckReturnValue
    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        int first = this.negate().indexIn(sequence);
        if (first == -1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(sequence.length());
        boolean inMatchingGroup = false;
        for (int i = first; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (this.matches(c)) {
                inMatchingGroup = true;
                continue;
            }
            if (inMatchingGroup) {
                builder.append(replacement);
                inMatchingGroup = false;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    @Override
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return this.description;
    }

    static {
        CharMatcher digit = CharMatcher.inRange('0', '9');
        String zeroes = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char base : zeroes.toCharArray()) {
            digit = digit.or(CharMatcher.inRange(base, (char)(base + 9)));
        }
        DIGIT = digit.withToString("CharMatcher.DIGIT").precomputed();
        JAVA_DIGIT = new CharMatcher("CharMatcher.JAVA_DIGIT"){

            @Override
            public boolean matches(char c) {
                return Character.isDigit(c);
            }
        };
        JAVA_LETTER = new CharMatcher("CharMatcher.JAVA_LETTER"){

            @Override
            public boolean matches(char c) {
                return Character.isLetter(c);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher("CharMatcher.JAVA_LETTER_OR_DIGIT"){

            @Override
            public boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }
        };
        JAVA_UPPER_CASE = new CharMatcher("CharMatcher.JAVA_UPPER_CASE"){

            @Override
            public boolean matches(char c) {
                return Character.isUpperCase(c);
            }
        };
        JAVA_LOWER_CASE = new CharMatcher("CharMatcher.JAVA_LOWER_CASE"){

            @Override
            public boolean matches(char c) {
                return Character.isLowerCase(c);
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0604')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).withToString("CharMatcher.INVISIBLE").precomputed();
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).withToString("CharMatcher.SINGLE_WIDTH").precomputed();
        ANY = new CharMatcher("CharMatcher.ANY"){

            @Override
            public boolean matches(char c) {
                return true;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                return sequence.length() == 0 ? -1 : 0;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return start == length ? -1 : start;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                return sequence.length() - 1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                char[] array = new char[sequence.length()];
                Arrays.fill(array, replacement);
                return new String(array);
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                StringBuilder retval = new StringBuilder(sequence.length() * replacement.length());
                for (int i = 0; i < sequence.length(); ++i) {
                    retval.append(replacement);
                }
                return retval.toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return sequence.length() == 0 ? "" : String.valueOf(replacement);
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length();
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher negate() {
                return NONE;
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
        NONE = new CharMatcher("CharMatcher.NONE"){

            @Override
            public boolean matches(char c) {
                return false;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return -1;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                return ((Object)sequence).toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                Preconditions.checkNotNull(replacement);
                return ((Object)sequence).toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString();
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                return ((Object)sequence).toString();
            }

            @Override
            public int countIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return 0;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher negate() {
                return ANY;
            }

            @Override
            void setBits(LookupTable table) {
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
        WHITESPACE = new CharMatcher("CharMatcher.WHITESPACE"){
            private final char[] table = new char[]{'\u0001', '\u0000', '\u00a0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\t', '\n', '\u000b', '\f', '\r', '\u0000', '\u0000', '\u2028', '\u2029', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u202f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u3000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0085', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u205f', '\u1680', '\u0000', '\u0000', '\u180e', '\u0000', '\u0000', '\u0000'};

            @Override
            public boolean matches(char c) {
                return this.table[c % 79] == c;
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    private static final class LookupTable {
        int[] data = new int[2048];

        private LookupTable() {
        }

        void set(char index) {
            int n = index >> 5;
            this.data[n] = this.data[n] | '\u0001' << index;
        }

        boolean get(char index) {
            return (this.data[index >> 5] & '\u0001' << index) != 0;
        }
    }

    private static class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        Or(CharMatcher a, CharMatcher b, String description) {
            super(description);
            this.first = Preconditions.checkNotNull(a);
            this.second = Preconditions.checkNotNull(b);
        }

        Or(CharMatcher a, CharMatcher b) {
            this(a, b, "CharMatcher.or(" + a + ", " + b + ")");
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            return new Or(this, Preconditions.checkNotNull(other));
        }

        @Override
        public boolean matches(char c) {
            return this.first.matches(c) || this.second.matches(c);
        }

        @Override
        CharMatcher withToString(String description) {
            return new Or(this.first, this.second, description);
        }
    }

    private static class And
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        And(CharMatcher a, CharMatcher b) {
            this(a, b, "CharMatcher.and(" + a + ", " + b + ")");
        }

        And(CharMatcher a, CharMatcher b, String description) {
            super(description);
            this.first = Preconditions.checkNotNull(a);
            this.second = Preconditions.checkNotNull(b);
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            return new And(this, other);
        }

        @Override
        public boolean matches(char c) {
            return this.first.matches(c) && this.second.matches(c);
        }

        @Override
        CharMatcher withToString(String description) {
            return new And(this.first, this.second, description);
        }
    }
}

