/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import org.drools.games.GameConfiguration;
import org.drools.games.GameFrame;
import org.drools.games.GamePanel;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;

public class GameUI {
    private GameConfiguration conf;
    private GameFrame frame;
    private MyJPanel panel;
    KieSession ksession;

    public GameUI(KieSession ksession, GameConfiguration conf) {
        this.ksession = ksession;
        this.conf = conf;
    }

    public void init() {
        this.frame = new GameFrame();
        this.frame.setDefaultCloseOperation(this.conf.isExitOnClose() ? 3 : 2);
        this.frame.setResizable(false);
        this.frame.setBackground(Color.BLACK);
        this.frame.getContentPane().setBackground(Color.BLACK);
        this.frame.setSize(new Dimension(this.conf.getWindowWidth(), this.conf.getWindowHeight()));
        this.panel = new MyJPanel("", Color.BLACK);
        this.frame.add(this.panel);
        this.panel.init();
        this.panel.getBufferedImage();
        this.frame.setLocationRelativeTo(null);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public JPanel getCanvas() {
        return this.panel;
    }

    public Graphics getGraphics() {
        return this.panel.getGraphics2D();
    }

    public void repaint() {
        this.panel.disposeGraphics2D();
        this.frame.waitForPaint();
    }

    public class MyJPanel
    extends GamePanel {
        public MyJPanel(String name, Color color) {
            super(name, color);
        }

        public void init() {
            GameKeyListener klistener = new GameKeyListener(GameUI.this.ksession.getEntryPoint("KeyPressedStream"), GameUI.this.ksession.getEntryPoint("KeyReleasedStream"));
            this.addKeyListener(klistener);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MyJPanel.this.requestFocus();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.setPreferredSize(new Dimension(GameUI.this.conf.getWindowWidth(), GameUI.this.conf.getWindowHeight()));
            this.setSize(new Dimension(GameUI.this.conf.getWindowWidth(), GameUI.this.conf.getWindowHeight()));
            this.setBackground(Color.BLACK);
            this.setDoubleBuffered(true);
            this.setFocusable(true);
            this.requestFocus();
        }
    }

    public static class GameKeyListener
    implements KeyListener {
        EntryPoint keyPressedEntryPoint;
        EntryPoint keyReleasedEntryPoint;

        public GameKeyListener(EntryPoint keyPressedEntryPoint, EntryPoint keyReleasedEntryPoint) {
            this.keyPressedEntryPoint = keyPressedEntryPoint;
            this.keyReleasedEntryPoint = keyReleasedEntryPoint;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyPressedEntryPoint.insert(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyReleasedEntryPoint.insert(e);
        }
    }
}

