/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes.assembler;

import java.util.Map;
import org.drools.beliefs.bayes.BayesNetwork;
import org.drools.beliefs.bayes.JunctionTreeBuilder;
import org.drools.beliefs.bayes.assembler.BayesNetworkAssemblerError;
import org.drools.beliefs.bayes.assembler.BayesPackage;
import org.drools.beliefs.bayes.model.Bif;
import org.drools.beliefs.bayes.model.XmlBifParser;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;

public class BayesAssemblerService
implements KieAssemblerService {
    public ResourceType getResourceType() {
        return ResourceType.BAYES;
    }

    public void addResource(Object kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        JunctionTreeBuilder builder;
        BayesNetwork network;
        KnowledgeBuilder kb = (KnowledgeBuilder)kbuilder;
        Bif bif = XmlBifParser.loadBif(resource, kb.getErrors());
        if (bif == null) {
            return;
        }
        try {
            network = XmlBifParser.buildBayesNetwork(bif);
        }
        catch (Exception e) {
            kb.getErrors().add((Object)new BayesNetworkAssemblerError(resource, "Unable to parse opening Stream:\n" + e.toString()));
            return;
        }
        try {
            builder = new JunctionTreeBuilder(network);
        }
        catch (Exception e) {
            kb.getErrors().add((Object)new BayesNetworkAssemblerError(resource, "Unable to build Junction Tree:\n" + e.toString()));
            return;
        }
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        PackageRegistry pkgReg = kbuilderImpl.getOrCreatePackageRegistry(new PackageDescr(network.getPackageName()));
        InternalKnowledgePackage kpkgs = pkgReg.getPackage();
        Map rpkg = kpkgs.getResourceTypePackages();
        BayesPackage bpkg = (BayesPackage)rpkg.get(ResourceType.BAYES);
        if (bpkg == null) {
            bpkg = new BayesPackage();
            rpkg.put(ResourceType.BAYES, bpkg);
        }
        bpkg.addJunctionTree(network.getName(), builder.build());
    }
}

