/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.evaluators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.spi.Evaluator;
import org.drools.core.time.Interval;
import org.drools.mvel.evaluators.MvelEvaluator;

public abstract class BaseEvaluator
implements MvelEvaluator,
Externalizable {
    private Operator operator;
    private ValueType type;

    public BaseEvaluator() {
    }

    public BaseEvaluator(ValueType type, Operator operator) {
        this.type = type;
        this.operator = operator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operator = (Operator)in.readObject();
        this.type = (ValueType)in.readObject();
        if (this.type != null) {
            this.type = ValueType.determineValueType((Class)this.type.getClassType());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.operator);
        out.writeObject(this.type);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public ValueType getValueType() {
        return this.type;
    }

    public ValueType getCoercedValueType() {
        return this.type;
    }

    public boolean isTemporal() {
        return false;
    }

    public Interval getInterval() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BaseEvaluator)) {
            return false;
        }
        Evaluator other = (Evaluator)object;
        return this.getOperator() == other.getOperator() && this.getValueType() == other.getValueType();
    }

    public int hashCode() {
        return this.getValueType().hashCode() ^ this.getOperator().hashCode() ^ this.getClass().hashCode();
    }

    public String toString() {
        return this.type.getName() + " " + this.operator.toString();
    }
}

