/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.compiler.rule.builder.util.PackageBuilderUtil;
import org.drools.core.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MultiAccumulate;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SingleAccumulate;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.TupleValueExtractor;
import org.drools.core.util.index.IndexUtil;
import org.drools.drl.ast.descr.AccumulateDescr;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.mvel.MVELConstraint;
import org.drools.mvel.builder.MVELExprAnalyzer;
import org.drools.mvel.java.JavaAnalysisResult;
import org.drools.mvel.java.JavaRuleBuilderHelper;
import org.kie.api.runtime.rule.AccumulateFunction;

public class JavaAccumulateBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        RuleConditionBuilder builder;
        RuleConditionElement source;
        AccumulateDescr accumDescr = (AccumulateDescr)descr;
        if (!accumDescr.hasValidInput()) {
            return null;
        }
        BaseDescr input = accumDescr.getInput();
        if (input instanceof AndDescr && ((AndDescr)input).getDescrs().size() == 1) {
            input = (BaseDescr)((AndDescr)input).getDescrs().get(0);
        }
        if ((source = (builder = (RuleConditionBuilder)context.getDialect().getBuilder(input.getClass())).build(context, input)) == null) {
            return null;
        }
        boolean readLocalsFromTuple = PackageBuilderUtil.isReadLocalsFromTuple((RuleBuildContext)context, (AccumulateDescr)accumDescr, (RuleConditionElement)source);
        Map declsInScope = context.getDeclarationResolver().getDeclarations(context.getRule());
        if (prefixPattern != null && prefixPattern.getDeclaration() != null) {
            declsInScope.remove(prefixPattern.getDeclaration().getIdentifier());
        }
        Map declCls = DeclarationScopeResolver.getDeclarationClasses((Map)declsInScope);
        Accumulate accumulate = accumDescr.isExternalFunction() ? this.buildExternalFunctionCall(context, accumDescr, source, declsInScope, declCls, readLocalsFromTuple) : this.buildInlineAccumulate(context, accumDescr, source, declsInScope, declCls, readLocalsFromTuple);
        return accumulate;
    }

    private Accumulate buildExternalFunctionCall(RuleBuildContext context, AccumulateDescr accumDescr, RuleConditionElement source, Map<String, Declaration> declsInScope, Map<String, Class<?>> declCls, boolean readLocalsFromTuple) {
        List funcCalls = accumDescr.getFunctions();
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]);
        Arrays.sort(sourceDeclArr, RuleTerminalNode.SortDeclarations.instance);
        HashSet<Declaration> requiredDecl = new HashSet<Declaration>();
        Pattern pattern = (Pattern)context.getDeclarationResolver().peekBuildStack();
        if (accumDescr.isMultiFunction()) {
            Accumulator[] accumulators = new Accumulator[funcCalls.size()];
            SelfReferenceClassFieldReader reader = new SelfReferenceClassFieldReader(Object[].class);
            int index = 0;
            for (AccumulateDescr.AccumulateFunctionCallDescr fc : funcCalls) {
                AccumulateFunction function = this.getAccumulateFunction(context, accumDescr, fc, source, declCls);
                if (function == null) {
                    return null;
                }
                this.bindReaderToDeclaration(context, accumDescr, pattern, fc, (InternalReadAccessor)new ArrayElementReader((InternalReadAccessor)reader, index, function.getResultType()), function.getResultType(), index);
                accumulators[index++] = this.buildAccumulator(context, accumDescr, declsInScope, declCls, readLocalsFromTuple, sourceDeclArr, requiredDecl, fc, function);
            }
            return new MultiAccumulate(source, requiredDecl.toArray(new Declaration[requiredDecl.size()]), accumulators, accumulators.length);
        }
        AccumulateDescr.AccumulateFunctionCallDescr fc = (AccumulateDescr.AccumulateFunctionCallDescr)accumDescr.getFunctions().get(0);
        AccumulateFunction function = this.getAccumulateFunction(context, accumDescr, fc, source, declCls);
        if (function == null) {
            return null;
        }
        Class returnType = function.getResultType();
        if (!pattern.isCompatibleWithAccumulateReturnType(returnType)) {
            context.addError((DroolsError)new DescrBuildError((BaseDescr)accumDescr, (BaseDescr)context.getRuleDescr(), null, "Pattern of type: '" + pattern.getObjectType() + "' on rule '" + context.getRuleDescr().getName() + "' is not compatible with type " + returnType.getCanonicalName() + " returned by accumulate function."));
            return null;
        }
        this.bindReaderToDeclaration(context, accumDescr, pattern, fc, (InternalReadAccessor)new SelfReferenceClassFieldReader(function.getResultType()), function.getResultType(), -1);
        Accumulator accumulator = this.buildAccumulator(context, accumDescr, declsInScope, declCls, readLocalsFromTuple, sourceDeclArr, requiredDecl, fc, function);
        return new SingleAccumulate(source, requiredDecl.toArray(new Declaration[requiredDecl.size()]), accumulator);
    }

    private void bindReaderToDeclaration(RuleBuildContext context, AccumulateDescr accumDescr, Pattern pattern, AccumulateDescr.AccumulateFunctionCallDescr fc, InternalReadAccessor readAccessor, Class<?> resultType, int index) {
        if (fc.getBind() != null) {
            if (context.getDeclarationResolver().isDuplicated(context.getRule(), fc.getBind(), resultType.getName())) {
                if (!fc.isUnification()) {
                    context.addError((DroolsError)new DescrBuildError(context.getParentDescr(), (BaseDescr)accumDescr, null, "Duplicate declaration for variable '" + fc.getBind() + "' in the rule '" + context.getRule().getName() + "'"));
                } else {
                    Declaration inner = context.getDeclarationResolver().getDeclaration(fc.getBind());
                    MVELConstraint c = new MVELConstraint(Collections.singletonList(context.getPkg().getName()), index >= 0 ? "this[ " + index + " ] == " + fc.getBind() : "this == " + fc.getBind(), new Declaration[]{inner}, null, null, IndexUtil.ConstraintType.EQUAL, (TupleValueExtractor)context.getDeclarationResolver().getDeclaration(fc.getBind()), (InternalReadAccessor)(index >= 0 ? new ArrayElementReader(readAccessor, index, resultType) : readAccessor), true);
                    ((MutableTypeConstraint)c).setType(Constraint.ConstraintType.BETA);
                    pattern.addConstraint((Constraint)c);
                }
            } else {
                Declaration declr = pattern.addDeclaration(fc.getBind());
                declr.setReadAccessor(readAccessor);
            }
        }
    }

    private AccumulateFunction getAccumulateFunction(RuleBuildContext context, AccumulateDescr accumDescr, AccumulateDescr.AccumulateFunctionCallDescr fc, RuleConditionElement source, Map<String, Class<?>> declCls) {
        String functionName = AccumulateUtil.getFunctionName(() -> MVELExprAnalyzer.getExpressionType((PackageBuildContext)context, declCls, source, fc.getParams()[0]), (String)fc.getFunction());
        AccumulateFunction function = context.getConfiguration().getAccumulateFunction(functionName);
        if (function == null) {
            function = (AccumulateFunction)context.getPkg().getAccumulateFunctions().get(functionName);
        }
        if (function == null) {
            context.addError((DroolsError)new DescrBuildError((BaseDescr)accumDescr, (BaseDescr)context.getRuleDescr(), null, "Unknown accumulate function: '" + functionName + "' on rule '" + context.getRuleDescr().getName() + "'. All accumulate functions must be registered before building a resource."));
        }
        return function;
    }

    private Accumulator buildAccumulator(RuleBuildContext context, AccumulateDescr accumDescr, Map<String, Declaration> declsInScope, Map<String, Class<?>> declCls, boolean readLocalsFromTuple, Declaration[] sourceDeclArr, Set<Declaration> requiredDecl, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function) {
        JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)accumDescr, fc.getParams().length > 0 ? fc.getParams()[0] : "\"\"", new BoundIdentifiers(declCls, (PackageBuildContext)context));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        Declaration[] previousDeclarations = this.collectRequiredDeclarations(declsInScope, requiredDecl, usedIdentifiers);
        return this.generateFunctionCallCodeTemplate(context, accumDescr, sourceDeclArr, fc, function, usedIdentifiers, previousDeclarations, readLocalsFromTuple);
    }

    private Declaration[] collectRequiredDeclarations(Map<String, Declaration> declsInScope, Set<Declaration> requiredDecl, BoundIdentifiers usedIdentifiers) {
        Declaration[] previousDeclarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
        int i = 0;
        for (String key : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration d = declsInScope.get(key);
            previousDeclarations[i++] = d;
            requiredDecl.add(d);
        }
        return previousDeclarations;
    }

    private JavaAccumulatorFunctionExecutor generateFunctionCallCodeTemplate(RuleBuildContext context, AccumulateDescr accumDescr, Declaration[] sourceDeclArr, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function, BoundIdentifiers usedIdentifiers, Declaration[] previousDeclarations, boolean readLocalsFromTuple) {
        String className = "accumulateExpression" + context.getNextId();
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, fc.getParams().length > 0 ? fc.getParams()[0] : "\"\"", context, previousDeclarations, sourceDeclArr, usedIdentifiers.getGlobals());
        map.put("readLocalsFromTuple", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
        JavaAccumulatorFunctionExecutor accumulator = new JavaAccumulatorFunctionExecutor(function);
        JavaRuleBuilderHelper.generateTemplates("returnValueMethod", "returnValueInvoker", context, className, map, accumulator, (BaseDescr)accumDescr);
        return accumulator;
    }

    private Accumulate buildInlineAccumulate(RuleBuildContext context, AccumulateDescr accumDescr, RuleConditionElement source, Map<String, Declaration> decls, Map<String, Class<?>> declCls, boolean readLocalsFromTuple) {
        String className = "Accumulate" + context.getNextId();
        accumDescr.setClassName(className);
        BoundIdentifiers available = new BoundIdentifiers(declCls, (PackageBuildContext)context);
        JavaAnalysisResult initCodeAnalysis = (JavaAnalysisResult)context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)accumDescr, accumDescr.getInitCode(), available);
        AnalysisResult actionCodeAnalysis = context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)accumDescr, accumDescr.getActionCode(), available);
        AnalysisResult resultCodeAnalysis = context.getDialect().analyzeExpression((PackageBuildContext)context, (BaseDescr)accumDescr, (Object)accumDescr.getResultCode(), available);
        if (initCodeAnalysis == null || actionCodeAnalysis == null || resultCodeAnalysis == null) {
            return null;
        }
        HashSet requiredDeclarations = new HashSet(initCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
        requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
        requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
        HashMap requiredGlobals = new HashMap(initCodeAnalysis.getBoundIdentifiers().getGlobals());
        requiredGlobals.putAll(actionCodeAnalysis.getBoundIdentifiers().getGlobals());
        requiredGlobals.putAll(resultCodeAnalysis.getBoundIdentifiers().getGlobals());
        if (accumDescr.getReverseCode() != null) {
            AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock((PackageBuildContext)context, (BaseDescr)accumDescr, accumDescr.getActionCode(), available);
            requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
            requiredGlobals.putAll(reverseCodeAnalysis.getBoundIdentifiers().getGlobals());
        }
        Declaration[] declarations = new Declaration[requiredDeclarations.size()];
        int i = 0;
        Iterator it = requiredDeclarations.iterator();
        while (it.hasNext()) {
            declarations[i] = decls.get(it.next());
            ++i;
        }
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[source.getOuterDeclarations().size()]);
        Arrays.sort(sourceDeclArr, RuleTerminalNode.SortDeclarations.instance);
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, null, context, declarations, null, requiredGlobals);
        map.put("className", accumDescr.getClassName());
        map.put("innerDeclarations", sourceDeclArr);
        map.put("isMultiPattern", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
        String initCode = this.fixInitCode(initCodeAnalysis, accumDescr.getInitCode());
        String actionCode = accumDescr.getActionCode();
        String resultCode = accumDescr.getResultCode();
        String[] attributesTypes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
        String[] attributes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
        int index = 0;
        for (Map.Entry<String, JavaLocalDeclarationDescr> entry : initCodeAnalysis.getLocalVariablesMap().entrySet()) {
            attributes[index] = entry.getKey();
            attributesTypes[index] = entry.getValue().getType();
            ++index;
        }
        map.put("attributes", attributes);
        map.put("attributesTypes", attributesTypes);
        map.put("initCode", initCode);
        map.put("actionCode", actionCode);
        map.put("resultCode", resultCode);
        if (accumDescr.getReverseCode() == null) {
            map.put("reverseCode", "");
            map.put("supportsReverse", "false");
        } else {
            map.put("reverseCode", accumDescr.getReverseCode());
            map.put("supportsReverse", "true");
        }
        map.put("hashCode", actionCode.hashCode());
        SingleAccumulate accumulate = new SingleAccumulate(source, declarations);
        JavaRuleBuilderHelper.generateTemplates("accumulateInnerClass", "accumulateInvoker", context, className, map, new SingleAccumulate.Wirer(accumulate), (BaseDescr)accumDescr);
        return accumulate;
    }

    public String fixInitCode(JavaAnalysisResult analysis, String originalCode) {
        TreeSet<JavaLocalDeclarationDescr> locals = new TreeSet<JavaLocalDeclarationDescr>(new Comparator<JavaLocalDeclarationDescr>(){

            @Override
            public int compare(JavaLocalDeclarationDescr o1, JavaLocalDeclarationDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        for (JavaLocalDeclarationDescr local : analysis.getLocalVariablesMap().values()) {
            locals.add(local);
        }
        StringBuilder initCode = new StringBuilder();
        int lastAdded = 0;
        for (JavaLocalDeclarationDescr d : locals) {
            initCode.append(originalCode.substring(lastAdded, d.getStart()));
            lastAdded = d.getEnd();
            for (JavaLocalDeclarationDescr.IdentifierDescr id : d.getIdentifiers()) {
                initCode.append(originalCode.substring(id.getStart(), id.getEnd()));
                initCode.append(";");
                for (lastAdded = id.getEnd(); lastAdded < originalCode.length() && (Character.isWhitespace(originalCode.charAt(lastAdded)) || originalCode.charAt(lastAdded) == ';'); ++lastAdded) {
                }
            }
        }
        initCode.append(originalCode.substring(lastAdded));
        return initCode.toString();
    }
}

