/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesFact;
import org.drools.beliefs.bayes.BayesHardEvidence;
import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.NonConflictingModeSet;
import org.drools.beliefs.bayes.PropertyReference;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.tms.LogicalDependency;
import org.drools.tms.agenda.TruthMaintenanceSystemActivation;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.ModedAssertion;
import org.drools.tms.beliefsystem.simple.SimpleLogicalDependency;

public class BayesBeliefSystem<M extends BayesHardEvidence<M>>
implements BeliefSystem<M> {
    private final NamedEntryPoint ep;
    private final TruthMaintenanceSystem tms;

    public BayesBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    public BeliefSet<M> insert(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        return this.insert((M)((Object)((BayesHardEvidence)node.getMode())), node.getJustifier().getRule(), node.getJustifier(), node.getObject(), beliefSet, context, typeConf);
    }

    public BeliefSet<M> insert(M mode, RuleImpl rule, TruthMaintenanceSystemActivation activation, Object ldPayload, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean wasDecided = beliefSet.isDecided();
        beliefSet.add(mode);
        BayesHardEvidence evidence = (BayesHardEvidence)beliefSet.getFirst();
        PropertyReference propRef = (PropertyReference)ldPayload;
        BayesFact bayesFact = (BayesFact)propRef.getInstance();
        BayesInstance bayesInstance = bayesFact.getBayesInstance();
        InternalFactHandle fh = beliefSet.getFactHandle();
        BayesVariable var = bayesInstance.getFieldNames().get(propRef.getName());
        if (wasDecided && !beliefSet.isDecided()) {
            bayesInstance.setDecided(var, false);
            bayesInstance.setLikelyhood(var, null);
        } else {
            bayesInstance.setDecided(var, true);
            bayesInstance.setLikelyhood(var, evidence.getDistribution());
        }
        return beliefSet;
    }

    public void delete(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context) {
        this.delete((M)((Object)((BayesHardEvidence)node.getMode())), node.getJustifier().getRule(), (Activation)node.getJustifier(), node.getObject(), beliefSet, context);
    }

    public void delete(M mode, RuleImpl rule, Activation activation, Object payload, BeliefSet<M> beliefSet, PropagationContext context) {
        boolean wasDecided = beliefSet.isDecided();
        beliefSet.remove(mode);
        PropertyReference propRef = (PropertyReference)payload;
        BayesFact bayesFact = (BayesFact)propRef.getInstance();
        BayesInstance bayesInstance = bayesFact.getBayesInstance();
        BayesVariable var = bayesInstance.getFieldNames().get(propRef.getName());
        boolean empty = beliefSet.isEmpty();
        if (empty) {
            bayesInstance.unsetLikelyhood(var);
            return;
        }
        BayesHardEvidence evidence = (BayesHardEvidence)beliefSet.getFirst();
        if (wasDecided && !beliefSet.isDecided()) {
            bayesInstance.setDecided(var, false);
            bayesInstance.unsetLikelyhood(var);
        } else if (!wasDecided && beliefSet.isDecided()) {
            bayesInstance.setDecided(var, true);
            bayesInstance.setLikelyhood(var, evidence.getDistribution());
        }
    }

    public void stage(PropagationContext context, BeliefSet<M> beliefSet) {
    }

    public void unstage(PropagationContext context, BeliefSet<M> beliefSet) {
    }

    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new NonConflictingModeSet(fh, this);
    }

    public LogicalDependency<M> newLogicalDependency(TruthMaintenanceSystemActivation<M> activation, BeliefSet<M> beliefSet, Object object, Object value) {
        BayesHardEvidence mode = (BayesHardEvidence)((Object)value);
        SimpleLogicalDependency dep = new SimpleLogicalDependency(activation, beliefSet, object, (ModedAssertion)((BayesHardEvidence)((Object)value)));
        mode.setLogicalDependency(dep);
        return dep;
    }

    public void read(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return null;
    }

    public M asMode(Object value) {
        return (M)((Object)((BayesHardEvidence)((Object)value)));
    }
}

