/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.core.base.ValueType;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.facttemplates.Fact;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;

public class FactTemplateFieldExtractor
implements Externalizable,
InternalReadAccessor {
    private static final long serialVersionUID = 510L;
    private FactTemplate factTemplate;
    private int fieldIndex;

    public FactTemplateFieldExtractor() {
    }

    public FactTemplateFieldExtractor(FactTemplate factTemplate, int fieldIndex) {
        this.factTemplate = factTemplate;
        this.fieldIndex = fieldIndex;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factTemplate = (FactTemplate)in.readObject();
        this.fieldIndex = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factTemplate);
        out.writeInt(this.fieldIndex);
    }

    @Override
    public ValueType getValueType() {
        return this.factTemplate.getFieldTemplate(this.fieldIndex).getValueType();
    }

    @Override
    public Object getValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Fact)object).getFieldValue(this.fieldIndex);
    }

    @Override
    public int getIndex() {
        return this.fieldIndex;
    }

    public Class getExtractToClass() {
        return this.factTemplate.getFieldTemplate(this.fieldIndex).getValueType().getClassType();
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.getExtractToClass());
    }

    @Override
    public boolean getBooleanValue(ReteEvaluator reteEvaluator, Object object) {
        return (Boolean)((Fact)object).getFieldValue(this.fieldIndex);
    }

    @Override
    public byte getByteValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).byteValue();
    }

    @Override
    public char getCharValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Character)((Fact)object).getFieldValue(this.fieldIndex)).charValue();
    }

    @Override
    public double getDoubleValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).doubleValue();
    }

    @Override
    public float getFloatValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).floatValue();
    }

    @Override
    public int getIntValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).intValue();
    }

    @Override
    public long getLongValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).longValue();
    }

    @Override
    public short getShortValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Number)((Fact)object).getFieldValue(this.fieldIndex)).shortValue();
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int getHashCode(ReteEvaluator reteEvaluator, Object object) {
        return this.getValue(reteEvaluator, object).hashCode();
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public boolean isNullValue(ReteEvaluator reteEvaluator, Object object) {
        return ((Fact)object).getFieldValue(this.fieldIndex) == null;
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.factTemplate == null ? 0 : this.factTemplate.hashCode());
        result = 31 * result + this.fieldIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FactTemplateFieldExtractor other = (FactTemplateFieldExtractor)obj;
        if (this.factTemplate == null ? other.factTemplate != null : !this.factTemplate.equals(other.factTemplate)) {
            return false;
        }
        return this.fieldIndex == other.fieldIndex;
    }
}

