/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Arrays;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.index.TupleList;

public class TimerNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<TimerNodeMemory> {
    private static final long serialVersionUID = 510L;
    private Timer timer;
    private String[] calendarNames;
    private boolean tupleMemoryEnabled;
    private Declaration[][] startEndDeclarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public TimerNode() {
    }

    public TimerNode(int id, LeftTupleSource tupleSource, Timer timer, String[] calendarNames, Declaration[][] startEndDeclarations, BuildContext context) {
        super(id, context);
        this.setLeftTupleSource(tupleSource);
        this.setObjectCount(this.leftInput.getObjectCount());
        this.timer = timer;
        this.calendarNames = calendarNames;
        this.startEndDeclarations = startEndDeclarations;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.initMasks(context, tupleSource);
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public String[] getCalendarNames() {
        return this.calendarNames;
    }

    public Declaration[][] getStartEndDeclarations() {
        return this.startEndDeclarations;
    }

    @Override
    protected Pattern getLeftInputPattern(BuildContext context) {
        return context.getLastBuiltPatterns()[0];
    }

    @Override
    public String toString() {
        return "[TimerNode(" + this.id + "): cond=" + this.timer + " calendars=" + (this.calendarNames == null ? "null" : Arrays.asList(this.calendarNames)) + "]";
    }

    private int calculateHashCode() {
        int hash = this.leftInput.hashCode() ^ this.timer.hashCode();
        if (this.calendarNames != null) {
            for (String calendarName : this.calendarNames) {
                hash ^= calendarName.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof TimerNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        TimerNode other = (TimerNode)object;
        if (this.leftInput.getId() != other.leftInput.getId()) {
            return false;
        }
        if (this.calendarNames != null) {
            if (other.getCalendarNames() == null || other.getCalendarNames().length != this.calendarNames.length) {
                return false;
            }
            for (int i = 0; i < this.calendarNames.length; ++i) {
                if (other.getCalendarNames()[i].equals(this.calendarNames[i])) continue;
                return false;
            }
        }
        return Arrays.deepEquals((Object[])this.startEndDeclarations, (Object[])other.startEndDeclarations) && this.timer.equals(other.timer);
    }

    @Override
    public TimerNodeMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return new TimerNodeMemory();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        EvalNodeLeftTuple peer = new EvalNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 133;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new EvalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new EvalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    public static class TimerNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        private static final long serialVersionUID = 510L;
        private TupleList insertOrUpdateLeftTuples = new TupleList();
        private TupleList deleteLeftTuples = new TupleList();
        private SegmentMemory memory;
        private long nodePosMaskBit;

        public TupleList getInsertOrUpdateLeftTuples() {
            return this.insertOrUpdateLeftTuples;
        }

        public TupleList getDeleteLeftTuples() {
            return this.deleteLeftTuples;
        }

        @Override
        public short getNodeType() {
            return 133;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.memory;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.memory = smem;
        }

        @Override
        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.nodePosMaskBit = segmentPos;
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.memory.updateDirtyNodeMask(this.nodePosMaskBit);
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.memory.updateCleanNodeMask(this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.insertOrUpdateLeftTuples.clear();
            this.deleteLeftTuples.clear();
        }
    }
}

