/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.waltz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.benchmark.waltz.Line;
import org.drools.benchmark.waltz.Stage;
import org.drools.core.util.IoUtils;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.RuleRuntime;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public abstract class WaltzBenchmark {
    public static void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"waltz.drl", WaltzBenchmark.class), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(pkgs);
        long totalTime = 0L;
        for (int i = 0; i < 5; ++i) {
            String arg;
            KieSession session = kbase.newKieSession();
            String filename = args.length != 0 ? (arg = args[0]) : "waltz50.dat";
            WaltzBenchmark.loadLines((RuleRuntime)session, filename);
            Stage stage = new Stage(1);
            session.insert((Object)stage);
            long start = System.currentTimeMillis();
            session.setGlobal("time", (Object)start);
            session.fireAllRules();
            long time = System.currentTimeMillis() - start;
            System.err.println(time);
            totalTime += time;
            session.dispose();
        }
        System.out.println("average : " + totalTime / 5L);
    }

    private static void loadLines(RuleRuntime wm, String filename) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(WaltzBenchmark.class.getResourceAsStream("data/" + filename), IoUtils.UTF8_CHARSET));
            Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
            String line = reader.readLine();
            while (line != null) {
                Matcher m = pat.matcher(line);
                if (m.matches()) {
                    Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                    wm.insert((Object)l);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file with filename (" + filename + ").", e);
        }
    }
}

