/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.builder.impl.CompositeKnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.DefaultTypeDeclarationBuilderFactory;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDeclarationBuilderFactory;
import org.drools.compiler.builder.impl.TypeDefinition;
import org.drools.compiler.builder.impl.errors.MissingImplementationException;
import org.drools.compiler.builder.impl.processors.AccumulateFunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.AnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.EntryPointDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompiler;
import org.drools.compiler.builder.impl.processors.GlobalCompilationPhase;
import org.drools.compiler.builder.impl.processors.OtherDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.PackageCompilationPhase;
import org.drools.compiler.builder.impl.processors.ReteCompiler;
import org.drools.compiler.builder.impl.processors.RuleAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.RuleCompiler;
import org.drools.compiler.builder.impl.processors.RuleValidator;
import org.drools.compiler.builder.impl.processors.TypeDeclarationAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.WindowDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.compiler.ConfigurableSeverityResult;
import org.drools.compiler.compiler.DroolsErrorWrapper;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.compiler.compiler.DroolsWarningWrapper;
import org.drools.compiler.compiler.DuplicateFunction;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageBuilderResults;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.compiler.ResourceTypeDeclarationWarning;
import org.drools.compiler.compiler.xml.XmlPackageReader;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.rule.builder.dialect.DialectError;
import org.drools.core.addon.TypeResolver;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.io.impl.ReaderResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.XmlChangeSetReader;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.drl.extensions.GuidedRuleTemplateFactory;
import org.drools.drl.extensions.GuidedRuleTemplateProvider;
import org.drools.drl.extensions.ResourceConversionResult;
import org.drools.drl.parser.BaseKnowledgeBuilderResultImpl;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsError;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.drl.parser.lang.ExpanderException;
import org.drools.drl.parser.lang.dsl.DSLMappingFile;
import org.drools.drl.parser.lang.dsl.DSLTokenizedMappingFile;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.wiring.api.ComponentsFactory;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Rule;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.internal.utils.KieService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.internal.ChangeSet;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResultSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class KnowledgeBuilderImpl
implements InternalKnowledgeBuilder {
    protected static final transient Logger logger = LoggerFactory.getLogger(KnowledgeBuilderImpl.class);
    private final Map<String, PackageRegistry> pkgRegistryMap = new ConcurrentHashMap<String, PackageRegistry>();
    private List<KnowledgeBuilderResult> results;
    private final KnowledgeBuilderConfigurationImpl configuration;
    private InternalKnowledgeBase kBase;
    private final String defaultDialect;
    private final ClassLoader rootClassLoader;
    private int parallelRulesBuildThreshold;
    private final Map<String, Class<?>> globals = new HashMap();
    private Resource resource;
    private List<DSLTokenizedMappingFile> dslFiles;
    private final ProcessBuilder processBuilder;
    private final Map<String, Map<String, AttributeDescr>> packageAttributes = new HashMap<String, Map<String, AttributeDescr>>();
    private final Map<String, List<PackageDescr>> packages = new ConcurrentHashMap<String, List<PackageDescr>>();
    private final Stack<List<Resource>> buildResources = new Stack();
    private AssetFilter assetFilter = null;
    private final TypeDeclarationBuilder typeBuilder;
    private Map<String, Object> builderCache;
    private ReleaseId releaseId;
    private BuildContext buildContext;

    public KnowledgeBuilderImpl() {
        this((InternalKnowledgeBase)null, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgePackage pkg) {
        this(pkg, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgeBase kBase) {
        this(kBase, null);
    }

    public KnowledgeBuilderImpl(KnowledgeBuilderConfigurationImpl configuration) {
        this((InternalKnowledgeBase)null, configuration);
    }

    public KnowledgeBuilderImpl(InternalKnowledgePackage pkg, KnowledgeBuilderConfigurationImpl configuration) {
        this.configuration = configuration == null ? new KnowledgeBuilderConfigurationImpl() : configuration;
        this.rootClassLoader = this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.parallelRulesBuildThreshold = this.configuration.getParallelRulesBuildThreshold();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        PackageRegistry pkgRegistry = new PackageRegistry(this.rootClassLoader, this.configuration, pkg);
        pkgRegistry.setDialect(this.defaultDialect);
        this.pkgRegistryMap.put(pkg.getName(), pkgRegistry);
        for (ImportDeclaration implDecl : pkg.getImports().values()) {
            pkgRegistry.addImport(new ImportDescr(implDecl.getTarget()));
        }
        this.processBuilder = ProcessBuilderFactory.newProcessBuilder(this);
        this.typeBuilder = this.createTypeDeclarationBuilder();
    }

    public KnowledgeBuilderImpl(InternalKnowledgeBase kBase, KnowledgeBuilderConfigurationImpl configuration) {
        this.configuration = configuration == null ? new KnowledgeBuilderConfigurationImpl() : configuration;
        this.rootClassLoader = kBase != null ? kBase.getRootClassLoader() : this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getDefaultDialect();
        this.parallelRulesBuildThreshold = this.configuration.getParallelRulesBuildThreshold();
        this.results = new ArrayList<KnowledgeBuilderResult>();
        this.kBase = kBase;
        this.processBuilder = ProcessBuilderFactory.newProcessBuilder(this);
        this.typeBuilder = this.createTypeDeclarationBuilder();
    }

    private TypeDeclarationBuilder createTypeDeclarationBuilder() {
        TypeDeclarationBuilderFactory typeDeclarationBuilderFactory = Optional.ofNullable((TypeDeclarationBuilderFactory)KieService.load(TypeDeclarationBuilderFactory.class)).orElse(new DefaultTypeDeclarationBuilderFactory());
        return typeDeclarationBuilderFactory.createTypeDeclarationBuilder(this);
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public BuildContext getBuildContext() {
        if (this.buildContext == null) {
            this.buildContext = this.createBuildContext();
        }
        return this.buildContext;
    }

    protected BuildContext createBuildContext() {
        return new BuildContext();
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    Resource getCurrentResource() {
        return this.resource;
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    TypeDeclarationBuilder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        this.addPackageFromDrl(reader, (Resource)new ReaderResource(reader, ResourceType.DRL));
    }

    public void addPackageFromDrl(Reader reader, Resource sourceResource) throws DroolsParserException, IOException {
        this.resource = sourceResource;
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(sourceResource, reader);
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.addBuilderResult((KnowledgeBuilderResult)new ParserError(sourceResource, "Parser returned a null Package", 0, 0));
        }
        if (!parser.hasErrors()) {
            this.addPackage(pkg);
        }
        this.resource = null;
    }

    public void addPackageFromDecisionTable(Resource resource, ResourceConfiguration configuration) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.decisionTableToPackageDescr(resource, configuration));
        this.resource = null;
    }

    PackageDescr decisionTableToPackageDescr(Resource resource, ResourceConfiguration configuration) throws DroolsParserException {
        DecisionTableConfiguration dtableConfiguration;
        Object object = dtableConfiguration = configuration instanceof DecisionTableConfiguration ? (DecisionTableConfiguration)configuration : new DecisionTableConfigurationImpl();
        if (!dtableConfiguration.getRuleTemplateConfigurations().isEmpty()) {
            List generatedDrls = DecisionTableFactory.loadFromInputStreamWithTemplates((Resource)resource, (DecisionTableConfiguration)dtableConfiguration);
            if (generatedDrls.size() == 1) {
                return this.generatedDrlToPackageDescr(resource, (String)generatedDrls.get(0));
            }
            CompositePackageDescr compositePackageDescr = null;
            for (String generatedDrl : generatedDrls) {
                PackageDescr packageDescr = this.generatedDrlToPackageDescr(resource, generatedDrl);
                if (packageDescr == null) continue;
                if (compositePackageDescr == null) {
                    compositePackageDescr = new CompositePackageDescr(resource, packageDescr);
                    continue;
                }
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            return compositePackageDescr;
        }
        dtableConfiguration.setTrimCell(this.configuration.isTrimCellsInDTable());
        String generatedDrl = DecisionTableFactory.loadFromResource((Resource)resource, (DecisionTableConfiguration)dtableConfiguration);
        return this.generatedDrlToPackageDescr(resource, generatedDrl);
    }

    private PackageDescr generatedDrlToPackageDescr(Resource resource, String generatedDrl) throws DroolsParserException {
        if (this.configuration.getDumpDir() != null) {
            this.dumpDrlGeneratedFromDTable(this.configuration.getDumpDir(), generatedDrl, resource.getSourcePath());
        }
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        PackageDescr pkg = parser.parse(resource, (Reader)new StringReader(generatedDrl));
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.addBuilderResult((KnowledgeBuilderResult)new ParserError(resource, "Parser returned a null Package", 0, 0));
        } else {
            pkg.setResource(resource);
        }
        return parser.hasErrors() ? null : pkg;
    }

    PackageDescr generatedDslrToPackageDescr(Resource resource, String dslr) throws DroolsParserException {
        return this.dslrReaderToPackageDescr(resource, new StringReader(dslr));
    }

    private void dumpDrlGeneratedFromDTable(File dumpDir, String generatedDrl, String srcPath) {
        String fileName;
        String string = fileName = srcPath != null ? srcPath : "decision-table-" + UUID.randomUUID();
        if (this.releaseId != null) {
            fileName = this.releaseId.getGroupId() + "_" + this.releaseId.getArtifactId() + "_" + fileName;
        }
        File dumpFile = KnowledgeBuilderImpl.createDumpDrlFile(dumpDir, fileName, ".drl");
        try {
            IoUtils.write((File)dumpFile, (byte[])generatedDrl.getBytes(IoUtils.UTF8_CHARSET));
        }
        catch (IOException ex) {
            logger.warn("Can't write the DRL generated from decision table to file " + dumpFile.getAbsolutePath() + "!\n" + Arrays.toString(ex.getStackTrace()));
        }
    }

    public static File createDumpDrlFile(File dumpDir, String fileName, String extension) {
        return new File(dumpDir, fileName.replaceAll("[^a-zA-Z0-9\\.\\-_]+", "_") + extension);
    }

    public void addPackageFromTemplate(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.templateToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr templateToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        GuidedRuleTemplateProvider guidedRuleTemplateProvider = GuidedRuleTemplateFactory.getGuidedRuleTemplateProvider();
        if (guidedRuleTemplateProvider == null) {
            throw new MissingImplementationException(resource, "drools-workbench-models-guided-template");
        }
        ResourceConversionResult conversionResult = guidedRuleTemplateProvider.loadFromInputStream(resource.getInputStream());
        return this.conversionResultToPackageDescr(resource, conversionResult);
    }

    private PackageDescr conversionResultToPackageDescr(Resource resource, ResourceConversionResult resourceConversionResult) throws DroolsParserException {
        ResourceType resourceType = resourceConversionResult.getType();
        if (ResourceType.DSLR.equals((Object)resourceType)) {
            return this.generatedDslrToPackageDescr(resource, resourceConversionResult.getContent());
        }
        if (ResourceType.DRL.equals((Object)resourceType)) {
            return this.generatedDrlToPackageDescr(resource, resourceConversionResult.getContent());
        }
        throw new RuntimeException("Converting generated " + resourceType + " into PackageDescr is not supported!");
    }

    public void addPackageFromDrl(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(new DrlResourceHandler(this.configuration).process(resource));
        this.resource = null;
    }

    public void addPackageFromXml(Reader reader) throws DroolsParserException, IOException {
        this.resource = new ReaderResource(reader, ResourceType.XDRL);
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader(this.rootClassLoader);
        try {
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        this.addPackage(xmlReader.getPackageDescr());
        this.resource = null;
    }

    public void addPackageFromXml(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.xmlToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr xmlToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        XmlPackageReader xmlReader = new XmlPackageReader(this.configuration.getSemanticModules());
        xmlReader.getParser().setClassLoader(this.rootClassLoader);
        try (Reader reader = resource.getReader();){
            xmlReader.read(reader);
        }
        catch (SAXException e) {
            throw new DroolsParserException(e.toString(), e.getCause());
        }
        return xmlReader.getPackageDescr();
    }

    public void addPackageFromDslr(Resource resource) throws DroolsParserException, IOException {
        this.resource = resource;
        this.addPackage(this.dslrToPackageDescr(resource));
        this.resource = null;
    }

    PackageDescr dslrToPackageDescr(Resource resource) throws DroolsParserException, IOException {
        return this.dslrReaderToPackageDescr(resource, resource.getReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageDescr dslrReaderToPackageDescr(Resource resource, Reader dslrReader) throws DroolsParserException {
        boolean hasErrors;
        PackageDescr pkg;
        DrlParser parser = new DrlParser(this.configuration.getLanguageLevel());
        DefaultExpander expander = this.getDslExpander();
        try {
            try {
                if (expander == null) {
                    expander = new DefaultExpander();
                }
                String str = expander.expand(dslrReader);
                if (expander.hasErrors()) {
                    for (ExpanderException error : expander.getErrors()) {
                        error.setResource(resource);
                        this.addBuilderResult((KnowledgeBuilderResult)error);
                    }
                }
                pkg = parser.parse(resource, str);
                this.results.addAll(parser.getErrors());
                hasErrors = parser.hasErrors();
            }
            finally {
                if (dslrReader != null) {
                    dslrReader.close();
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return hasErrors ? null : pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDsl(Resource resource) throws IOException {
        this.resource = resource;
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        try (Reader reader = resource.getReader();){
            if (!file.parseAndLoad(reader)) {
                this.results.addAll(file.getErrors());
            }
            if (this.dslFiles == null) {
                this.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
            }
            this.dslFiles.add(file);
        }
        finally {
            this.resource = null;
        }
    }

    public void addRuleFlow(Reader processSource) {
        this.addKnowledgeResource((Resource)new ReaderResource(processSource, ResourceType.DRF), ResourceType.DRF, null);
    }

    @Deprecated
    public void addProcessFromXml(Resource resource) {
        this.addKnowledgeResource(resource, resource.getResourceType(), resource.getConfiguration());
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    @Deprecated
    public void addProcessFromXml(Reader processSource) {
        this.addProcessFromXml((Resource)new ReaderResource(processSource, ResourceType.DRF));
    }

    public void addKnowledgeResource(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        try {
            ((InternalResource)resource).setResourceType(type);
            if (ResourceType.DRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.GDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.RDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.DESCR.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.DSLR.equals((Object)type)) {
                this.addPackageFromDslr(resource);
            } else if (ResourceType.RDSLR.equals((Object)type)) {
                this.addPackageFromDslr(resource);
            } else if (ResourceType.DSL.equals((Object)type)) {
                this.addDsl(resource);
            } else if (ResourceType.XDRL.equals((Object)type)) {
                this.addPackageFromXml(resource);
            } else if (ResourceType.DTABLE.equals((Object)type)) {
                this.addPackageFromDecisionTable(resource, configuration);
            } else if (ResourceType.PKG.equals((Object)type)) {
                this.addPackageFromInputStream(resource);
            } else if (ResourceType.CHANGE_SET.equals((Object)type)) {
                this.addPackageFromChangeSet(resource);
            } else if (ResourceType.XSD.equals((Object)type)) {
                this.addPackageFromXSD(resource, configuration);
            } else if (ResourceType.TDRL.equals((Object)type)) {
                this.addPackageFromDrl(resource);
            } else if (ResourceType.TEMPLATE.equals((Object)type)) {
                this.addPackageFromTemplate(resource);
            } else {
                this.addPackageForExternalType(resource, type, configuration);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    void addPackageForExternalType(Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        KieAssemblers assemblers = (KieAssemblers)KieService.load(KieAssemblers.class);
        assemblers.addResourceAfterRules((Object)this, resource, type, configuration);
    }

    @Deprecated
    void addPackageForExternalType(ResourceType type, List<ResourceWithConfiguration> resources) throws Exception {
        KieAssemblers assemblers = (KieAssemblers)KieService.load(KieAssemblers.class);
        assemblers.addResourcesAfterRules((Object)this, resources, type);
    }

    void addPackageFromXSD(Resource resource, ResourceConfiguration configuration) throws IOException {
        if (configuration != null) {
            ComponentsFactory.addPackageFromXSD((KnowledgeBuilder)this, (Resource)resource, (ResourceConfiguration)configuration);
        }
    }

    void addPackageFromChangeSet(Resource resource) throws SAXException, IOException {
        XmlChangeSetReader reader = new XmlChangeSetReader(this.configuration.getSemanticModules());
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), ((ClassPathResource)resource).getClazz());
        } else {
            reader.setClassLoader(this.configuration.getClassLoader(), null);
        }
        try (Reader resourceReader = resource.getReader();){
            ChangeSet changeSet = reader.read(resourceReader);
            if (changeSet == null) {
                throw new RuntimeException("ChangeSet cannot be read! " + resource);
            }
            for (Resource nestedResource : changeSet.getResourcesAdded()) {
                InternalResource iNestedResourceResource = (InternalResource)nestedResource;
                if (iNestedResourceResource.isDirectory()) {
                    for (Resource childResource : iNestedResourceResource.listResources()) {
                        if (((InternalResource)childResource).isDirectory()) continue;
                        ((InternalResource)childResource).setResourceType(iNestedResourceResource.getResourceType());
                        this.addKnowledgeResource(childResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
                    }
                    continue;
                }
                this.addKnowledgeResource((Resource)iNestedResourceResource, iNestedResourceResource.getResourceType(), iNestedResourceResource.getConfiguration());
            }
        }
    }

    void addPackageFromInputStream(final Resource resource) throws IOException, ClassNotFoundException {
        InputStream is = resource.getInputStream();
        Object object = DroolsStreamUtils.streamIn((InputStream)is, (ClassLoader)this.configuration.getClassLoader());
        is.close();
        if (object instanceof Collection) {
            Collection pkgs = (Collection)object;
            for (KiePackage kpkg : pkgs) {
                this.overrideReSource((InternalKnowledgePackage)((KnowledgePackageImpl)kpkg), resource);
                this.addPackage((InternalKnowledgePackage)((KnowledgePackageImpl)kpkg));
            }
        } else if (object instanceof KnowledgePackageImpl) {
            KnowledgePackageImpl kpkg = (KnowledgePackageImpl)object;
            this.overrideReSource((InternalKnowledgePackage)kpkg, resource);
            this.addPackage((InternalKnowledgePackage)kpkg);
        } else {
            this.results.add((KnowledgeBuilderResult)new DroolsError(resource){

                public String getMessage() {
                    return "Unknown binary format trying to load resource " + resource.toString();
                }

                public int[] getLines() {
                    return new int[0];
                }
            });
        }
    }

    private void overrideReSource(InternalKnowledgePackage pkg, Resource res) {
        for (Rule r : pkg.getRules()) {
            if (!this.isSwappable(((RuleImpl)r).getResource(), res)) continue;
            ((RuleImpl)r).setResource(res);
        }
        for (TypeDeclaration d : pkg.getTypeDeclarations().values()) {
            if (!this.isSwappable(d.getResource(), res)) continue;
            d.setResource(res);
        }
        for (org.drools.core.rule.Function f : pkg.getFunctions().values()) {
            if (!this.isSwappable(f.getResource(), res)) continue;
            f.setResource(res);
        }
        for (Process p : pkg.getRuleFlows().values()) {
            if (!this.isSwappable(p.getResource(), res)) continue;
            p.setResource(res);
        }
    }

    private boolean isSwappable(Resource original, Resource source) {
        return original == null || original instanceof ReaderResource && ((ReaderResource)original).getReader() == null;
    }

    @Override
    public void addPackage(PackageDescr packageDescr) {
        PackageRegistry pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return;
        }
        this.mergePackage(pkgRegistry, packageDescr);
        this.compileKnowledgePackages(packageDescr, pkgRegistry);
        this.wireAllRules();
        this.compileRete(pkgRegistry, packageDescr);
    }

    protected void compileKnowledgePackages(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        pkgRegistry.setDialect(this.getPackageDialect(packageDescr));
        PackageRegistry packageRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        Map<String, AttributeDescr> packageAttributes = this.packageAttributes.get(packageDescr.getNamespace());
        List<CompilationPhase> phases = Arrays.asList(new RuleValidator(packageRegistry, packageDescr, this.configuration), new FunctionCompiler(packageDescr, pkgRegistry, this::filterAccepts, this.rootClassLoader), new RuleCompiler(pkgRegistry, packageDescr, this.kBase, this.parallelRulesBuildThreshold, this::filterAccepts, this::filterAcceptsRemoval, packageAttributes, this.resource, this));
        phases.forEach(CompilationPhase::process);
        phases.forEach(p -> this.results.addAll(p.getResults()));
    }

    protected void wireAllRules() {
        this.compileAll();
        try {
            this.reloadAll();
        }
        catch (Exception e) {
            this.addBuilderResult((KnowledgeBuilderResult)new DialectError(null, "Unable to wire compiled classes, probably related to compilation failures:" + e.getMessage()));
        }
        this.updateResults();
    }

    protected void processKieBaseTypes() {
        if (!this.hasErrors() && this.kBase != null) {
            ArrayList<InternalKnowledgePackage> pkgs = new ArrayList<InternalKnowledgePackage>();
            for (PackageRegistry pkgReg : this.pkgRegistryMap.values()) {
                pkgs.add(pkgReg.getPackage());
            }
            this.kBase.processAllTypesDeclaration(pkgs);
        }
    }

    protected void compileRete(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        if (!this.hasErrors() && this.kBase != null) {
            ReteCompiler reteCompiler = new ReteCompiler(pkgRegistry, packageDescr, (RuleBase)this.kBase, this::filterAccepts);
            reteCompiler.process();
        }
    }

    public void addBuilderResult(KnowledgeBuilderResult result) {
        this.results.add(result);
    }

    public <T extends ResourceTypePackage<?>> T computeIfAbsent(ResourceType resourceType, String namespace, Function<? super ResourceType, T> mappingFunction) {
        PackageRegistry pkgReg = this.getOrCreatePackageRegistry(new PackageDescr(namespace));
        InternalKnowledgePackage kpkgs = pkgReg.getPackage();
        return (T)kpkgs.getResourceTypePackages().computeIfAbsent(resourceType, mappingFunction);
    }

    public PackageRegistry getOrCreatePackageRegistry(PackageDescr packageDescr) {
        if (packageDescr == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getDefaultPackageName());
        }
        return this.pkgRegistryMap.computeIfAbsent(packageDescr.getName(), name -> this.createPackageRegistry(packageDescr));
    }

    private PackageRegistry createPackageRegistry(PackageDescr packageDescr) {
        InternalKnowledgePackage pkg;
        this.initPackage(packageDescr);
        if (this.kBase == null || (pkg = this.kBase.getPackage(packageDescr.getName())) == null) {
            pkg = CoreComponentFactory.get().createKnowledgePackage(packageDescr.getName());
            pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.rootClassLoader));
            if (this.kBase != null) {
                try {
                    pkg = (InternalKnowledgePackage)this.kBase.addPackage((KiePackage)pkg).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
            }
        }
        PackageRegistry pkgRegistry = new PackageRegistry(this.rootClassLoader, this.configuration, pkg);
        pkgRegistry.addImport(new ImportDescr(packageDescr.getNamespace() + ".*"));
        for (ImportDescr importDescr : packageDescr.getImports()) {
            pkgRegistry.registerImport(importDescr.getTarget());
        }
        return pkgRegistry;
    }

    public void registerPackage(PackageDescr packageDescr) {
        if (StringUtils.isEmpty((CharSequence)packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getDefaultPackageName());
        }
        this.initPackage(packageDescr);
    }

    private void initPackage(PackageDescr packageDescr) {
        List packageDescrsForPackage = this.packages.computeIfAbsent(packageDescr.getName(), k -> new ArrayList());
        packageDescrsForPackage.add(packageDescr);
        HashSet imports = new HashSet();
        for (PackageDescr pd : packageDescrsForPackage) {
            imports.addAll(pd.getImports());
        }
        for (PackageDescr pd : packageDescrsForPackage) {
            pd.getImports().clear();
            pd.addAllImports(imports);
        }
        if (!packageDescr.getAttributes().isEmpty()) {
            Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
            if (pkgAttributes == null) {
                pkgAttributes = new HashMap<String, AttributeDescr>();
                this.packageAttributes.put(packageDescr.getNamespace(), pkgAttributes);
            }
            for (AttributeDescr attr : packageDescr.getAttributes()) {
                pkgAttributes.put(attr.getName(), attr);
            }
        }
    }

    boolean filterAccepts(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter == null || !AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private boolean filterAcceptsRemoval(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter != null && AssetFilter.Action.REMOVE.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private String getPackageDialect(PackageDescr packageDescr) {
        String dialectName = this.defaultDialect;
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        return dialectName;
    }

    public void updateResults() {
        this.updateResults(this.results);
    }

    public void updateResults(List<KnowledgeBuilderResult> results) {
        this.results = this.getResults(results);
    }

    public void compileAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.compileAll();
        }
    }

    public void reloadAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
        }
    }

    private List<KnowledgeBuilderResult> getResults(List<KnowledgeBuilderResult> results) {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            results = pkgRegistry.getDialectCompiletimeRegistry().addResults(results);
        }
        return results;
    }

    public synchronized void addPackage(InternalKnowledgePackage newPkg) {
        PackageRegistry pkgRegistry = this.pkgRegistryMap.get(newPkg.getName());
        InternalKnowledgePackage pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (pkg == null) {
            PackageDescr packageDescr = new PackageDescr(newPkg.getName());
            pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
            this.mergePackage(this.pkgRegistryMap.get(packageDescr.getNamespace()), packageDescr);
            pkg = pkgRegistry.getPackage();
        }
        pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
        if (newPkg.getFunctions() != null) {
            for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                if (pkg.getFunctions().containsKey(entry.getKey())) {
                    this.addBuilderResult((KnowledgeBuilderResult)new DuplicateFunction((org.drools.core.rule.Function)entry.getValue(), (KnowledgeBuilderConfiguration)this.configuration));
                }
                pkg.addFunction((org.drools.core.rule.Function)entry.getValue());
            }
        }
        pkg.mergeStore(newPkg);
        pkg.getDialectRuntimeRegistry().onBeforeExecute();
        TypeDeclaration lastType = null;
        try {
            if (newPkg.getTypeDeclarations() != null) {
                Iterator iterator = newPkg.getTypeDeclarations().values().iterator();
                while (iterator.hasNext()) {
                    TypeDeclaration type;
                    lastType = type = (TypeDeclaration)iterator.next();
                    type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
        }
        this.mergePackage(pkg, newPkg);
    }

    private void mergePackage(InternalKnowledgePackage pkg, InternalKnowledgePackage newPkg) {
        Map imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        if (newPkg.getGlobals() != null && !newPkg.getGlobals().isEmpty()) {
            Iterator pkgGlobals = pkg.getGlobals();
            for (Map.Entry entry : newPkg.getGlobals().entrySet()) {
                String identifier = (String)entry.getKey();
                Class type = (Class)entry.getValue();
                if (pkgGlobals.containsKey(identifier) && !((Class)pkgGlobals.get(identifier)).equals(type)) {
                    throw new RuntimeException(pkg.getName() + " cannot be integrated");
                }
                pkg.addGlobal(identifier, type);
                this.globals.put(identifier, type);
            }
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        for (Rule newRule : newPkg.getRules()) {
            pkg.addRule((RuleImpl)newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map flows = newPkg.getRuleFlows();
            for (Map.Entry o : flows.values()) {
                Process flow = (Process)o;
                pkg.addProcess(flow);
            }
        }
    }

    protected void validateUniqueRuleNames(PackageDescr packageDescr) {
        PackageRegistry packageRegistry = this.pkgRegistryMap.get(packageDescr.getNamespace());
        RuleValidator ruleValidator = new RuleValidator(packageRegistry, packageDescr, this.configuration);
        ruleValidator.process();
        this.results.addAll(ruleValidator.getResults());
    }

    void mergePackage(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        PackageCompilationPhase packageProcessor = new PackageCompilationPhase(this, this.kBase, this.configuration, this.typeBuilder, this::filterAcceptsRemoval, pkgRegistry, packageDescr);
        packageProcessor.process();
        this.results.addAll(packageProcessor.getResults());
    }

    protected void processOtherDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        OtherDeclarationCompilationPhase otherDeclarationProcessor = new OtherDeclarationCompilationPhase(this, this.kBase, this.configuration, this::filterAcceptsRemoval, pkgRegistry, packageDescr);
        otherDeclarationProcessor.process();
        this.results.addAll(otherDeclarationProcessor.getResults());
    }

    protected void processGlobals(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        GlobalCompilationPhase globalProcessor = new GlobalCompilationPhase(pkgRegistry, packageDescr, this.kBase, this, this::filterAcceptsRemoval);
        globalProcessor.process();
        this.results.addAll(globalProcessor.getResults());
    }

    protected void processAccumulateFunctions(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        AccumulateFunctionCompilationPhase accumulateFunctionProcessor = new AccumulateFunctionCompilationPhase(pkgRegistry, packageDescr);
        accumulateFunctionProcessor.process();
        this.results.addAll(accumulateFunctionProcessor.getResults());
    }

    protected void processFunctions(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        FunctionCompilationPhase functionProcessor = new FunctionCompilationPhase(pkgRegistry, packageDescr, this.configuration);
        functionProcessor.process();
        this.results.addAll(functionProcessor.getResults());
    }

    @Override
    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        TypeDeclaration typeDeclaration;
        InternalKnowledgePackage pkg;
        if (this.kBase != null && (pkg = this.kBase.getPackage(packageName)) != null && (typeDeclaration = pkg.getTypeDeclaration(cls)) != null) {
            return typeDeclaration;
        }
        return this.typeBuilder.getAndRegisterTypeDeclaration(cls, packageName);
    }

    void processEntryPointDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        EntryPointDeclarationCompilationPhase entryPointDeclarationProcessor = new EntryPointDeclarationCompilationPhase(pkgRegistry, packageDescr);
        entryPointDeclarationProcessor.process();
        this.results.addAll(entryPointDeclarationProcessor.getResults());
    }

    protected void processWindowDeclarations(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        WindowDeclarationCompilationPhase windowDeclarationProcessor = new WindowDeclarationCompilationPhase(pkgRegistry, packageDescr, this);
        windowDeclarationProcessor.process();
        this.results.addAll(windowDeclarationProcessor.getResults());
    }

    public InternalKnowledgePackage[] getPackages() {
        InternalKnowledgePackage[] pkgs = new InternalKnowledgePackage[this.pkgRegistryMap.size()];
        String errors = null;
        if (!this.getErrors().isEmpty()) {
            errors = this.getErrors().toString();
        }
        int i = 0;
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            InternalKnowledgePackage pkg = pkgRegistry.getPackage();
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            if (errors != null) {
                pkg.setError(errors);
            }
            pkgs[i++] = pkg;
        }
        return pkgs;
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getBuilderConfiguration() {
        return this.configuration;
    }

    @Override
    public PackageRegistry getPackageRegistry(String name) {
        return this.pkgRegistryMap.get(name);
    }

    @Override
    public InternalKnowledgePackage getPackage(String name) {
        PackageRegistry registry = this.pkgRegistryMap.get(name);
        return registry == null ? null : registry.getPackage();
    }

    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryMap;
    }

    public Collection<String> getPackageNames() {
        return this.pkgRegistryMap.keySet();
    }

    @Override
    public List<PackageDescr> getPackageDescrs(String packageName) {
        return this.packages.get(packageName);
    }

    public DefaultExpander getDslExpander() {
        DefaultExpander expander = new DefaultExpander();
        if (this.dslFiles == null || this.dslFiles.isEmpty()) {
            return null;
        }
        for (DSLMappingFile dSLMappingFile : this.dslFiles) {
            expander.addDSLMapping(dSLMappingFile.getMapping());
        }
        return expander;
    }

    @Override
    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public void addGlobal(String name, Class<?> type) {
        this.globals.put(name, type);
    }

    public boolean hasErrors() {
        return !this.getErrorList().isEmpty();
    }

    public KnowledgeBuilderResults getResults(ResultSeverity ... problemTypes) {
        List<KnowledgeBuilderResult> problems = this.getResultList(problemTypes);
        return new PackageBuilderResults(problems.toArray(new BaseKnowledgeBuilderResultImpl[problems.size()]));
    }

    private List<KnowledgeBuilderResult> getResultList(ResultSeverity ... severities) {
        List<ResultSeverity> typesToFetch = Arrays.asList(severities);
        ArrayList<KnowledgeBuilderResult> problems = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (!typesToFetch.contains(problem.getSeverity())) continue;
            problems.add(problem);
        }
        return problems;
    }

    public boolean hasResults(ResultSeverity ... problemTypes) {
        return !this.getResultList(problemTypes).isEmpty();
    }

    private List<DroolsError> getErrorList() {
        ArrayList<DroolsError> errors = new ArrayList<DroolsError>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.ERROR) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                errors.add(new DroolsErrorWrapper(problem));
                continue;
            }
            errors.add((DroolsError)problem);
        }
        return errors;
    }

    public boolean hasWarnings() {
        return !this.getWarnings().isEmpty();
    }

    public boolean hasInfo() {
        return !this.getInfoList().isEmpty();
    }

    public List<DroolsWarning> getWarnings() {
        ArrayList<DroolsWarning> warnings = new ArrayList<DroolsWarning>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.WARNING) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                warnings.add(new DroolsWarningWrapper(problem));
                continue;
            }
            warnings.add((DroolsWarning)problem);
        }
        return warnings;
    }

    private List<KnowledgeBuilderResult> getInfoList() {
        return this.getResultList(ResultSeverity.INFO);
    }

    public void reportError(KnowledgeBuilderError error) {
        this.getErrors().add(error);
    }

    @Override
    public PackageBuilderErrors getErrors() {
        List<DroolsError> errors = this.getErrorList();
        return new PackageBuilderErrors(errors.toArray(new DroolsError[errors.size()]));
    }

    public void resetErrors() {
        this.resetProblemType(ResultSeverity.ERROR);
    }

    public void resetWarnings() {
        this.resetProblemType(ResultSeverity.WARNING);
    }

    private void resetProblemType(ResultSeverity problemType) {
        ArrayList<KnowledgeBuilderResult> toBeDeleted = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problemType == null || !problemType.equals((Object)problem.getSeverity())) continue;
            toBeDeleted.add(problem);
        }
        this.results.removeAll(toBeDeleted);
    }

    public void resetProblems() {
        this.results.clear();
        if (this.processBuilder != null) {
            this.processBuilder.getErrors().clear();
        }
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    private ChangeSet parseChangeSet(Resource resource) throws IOException, SAXException {
        XmlChangeSetReader reader = new XmlChangeSetReader(this.configuration.getSemanticModules());
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), ((ClassPathResource)resource).getClazz());
        } else {
            reader.setClassLoader(this.configuration.getClassLoader(), null);
        }
        try (Reader resourceReader = resource.getReader();){
            ChangeSet changeSet = reader.read(resourceReader);
            return changeSet;
        }
    }

    public void registerBuildResource(final Resource resource, ResourceType type) {
        InternalResource ires = (InternalResource)resource;
        if (ires.getResourceType() == null) {
            ires.setResourceType(type);
        } else if (ires.getResourceType() != type) {
            this.addBuilderResult((KnowledgeBuilderResult)new ResourceTypeDeclarationWarning(resource, ires.getResourceType(), type));
        }
        if (ResourceType.CHANGE_SET == type) {
            try {
                ChangeSet changeSet = this.parseChangeSet(resource);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                resources.add(resource);
                resources.addAll(changeSet.getResourcesAdded());
                resources.addAll(changeSet.getResourcesModified());
                resources.addAll(changeSet.getResourcesRemoved());
                this.buildResources.push(resources);
            }
            catch (Exception e) {
                this.results.add((KnowledgeBuilderResult)new DroolsError(){

                    public String getMessage() {
                        return "Unable to register changeset resource " + resource;
                    }

                    public int[] getLines() {
                        return new int[0];
                    }
                });
            }
        } else {
            this.buildResources.push(Collections.singletonList(resource));
        }
    }

    public void registerBuildResources(List<Resource> resources) {
        this.buildResources.push(resources);
    }

    public void undo() {
        if (this.buildResources.isEmpty()) {
            return;
        }
        for (Resource resource : this.buildResources.pop()) {
            this.removeObjectsGeneratedFromResource(resource);
        }
    }

    @Override
    public InternalKnowledgeBuilder.ResourceRemovalResult removeObjectsGeneratedFromResource(Resource resource) {
        boolean modified = false;
        for (PackageRegistry packageRegistry : this.pkgRegistryMap.values()) {
            modified = packageRegistry.removeObjectsGeneratedFromResource(resource) || modified;
        }
        if (this.results != null) {
            this.results.removeIf(knowledgeBuilderResult -> resource.equals(knowledgeBuilderResult.getResource()));
        }
        if (this.processBuilder != null && this.processBuilder.getErrors() != null) {
            this.processBuilder.getErrors().removeIf(knowledgeBuilderResult -> resource.equals(knowledgeBuilderResult.getResource()));
        }
        if (this.results != null && this.results.size() == 0) {
            for (PackageRegistry packageRegistry : this.pkgRegistryMap.values()) {
                packageRegistry.getPackage().resetErrors();
            }
        }
        Collection<String> removedTypes = this.typeBuilder.removeTypesGeneratedFromResource(resource);
        for (List<PackageDescr> pkgDescrs : this.packages.values()) {
            for (PackageDescr pkgDescr : pkgDescrs) {
                pkgDescr.removeObjectsGeneratedFromResource(resource);
            }
        }
        if (this.kBase != null) {
            modified = this.kBase.removeObjectsGeneratedFromResource(resource, this.kBase.getWorkingMemories()) || modified;
        }
        return new InternalKnowledgeBuilder.ResourceRemovalResult(modified, removedTypes);
    }

    @Override
    public void rewireAllClassObjectTypes() {
        if (this.kBase != null) {
            for (InternalKnowledgePackage pkg : this.kBase.getPackagesMap().values()) {
                pkg.getDialectRuntimeRegistry().getDialectData("java").setDirty(true);
                pkg.wireStore();
            }
        }
    }

    public void setAssetFilter(AssetFilter assetFilter) {
        this.assetFilter = assetFilter;
    }

    public void add(Resource resource, ResourceType type) {
        ResourceConfiguration resourceConfiguration = resource instanceof BaseResource ? resource.getConfiguration() : null;
        this.add(resource, type, resourceConfiguration);
    }

    public CompositeKnowledgeBuilder batch() {
        return new CompositeKnowledgeBuilderImpl(this);
    }

    public void add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        this.registerBuildResource(resource, type);
        this.addKnowledgeResource(resource, type, configuration);
    }

    public Collection<KiePackage> getKnowledgePackages() {
        if (this.hasErrors()) {
            return new ArrayList<KiePackage>(0);
        }
        InternalKnowledgePackage[] pkgs = this.getPackages();
        ArrayList<KiePackage> list = new ArrayList<KiePackage>(pkgs.length);
        Collections.addAll(list, pkgs);
        return list;
    }

    public KieBase newKieBase() {
        return this.newKnowledgeBase(null);
    }

    public KieBase newKnowledgeBase(KieBaseConfiguration conf) {
        PackageBuilderErrors errors = this.getErrors();
        if (!errors.isEmpty()) {
            for (KnowledgeBuilderError error : errors) {
                logger.error(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge. See the logs for details.");
        }
        RuleBase kbase = RuleBaseFactory.newRuleBase((KieBaseConfiguration)conf);
        kbase.addPackages(Arrays.asList(this.getPackages()));
        return KnowledgeBaseFactory.newKnowledgeBase((RuleBase)kbase);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        return cls != null ? this.typeBuilder.getTypeDeclaration(cls) : null;
    }

    @Override
    public TypeDeclaration getTypeDeclaration(ObjectType objectType) {
        return objectType.isTemplate() ? this.typeBuilder.getExistingTypeDeclaration(objectType.getClassName()) : this.typeBuilder.getTypeDeclaration(((ClassObjectType)objectType).getClassType());
    }

    public void normalizeTypeDeclarationAnnotations(PackageDescr packageDescr, TypeResolver typeResolver) {
        AnnotationNormalizer annotationNormalizer = AnnotationNormalizer.of(typeResolver, this.configuration.getLanguageLevel().useJavaAnnotations());
        TypeDeclarationAnnotationNormalizer typeDeclarationAnnotationNormalizer = new TypeDeclarationAnnotationNormalizer(annotationNormalizer, packageDescr);
        typeDeclarationAnnotationNormalizer.process();
        this.results.addAll(typeDeclarationAnnotationNormalizer.getResults());
    }

    public void normalizeRuleAnnotations(PackageDescr packageDescr, TypeResolver typeResolver) {
        AnnotationNormalizer annotationNormalizer = AnnotationNormalizer.of(typeResolver, this.configuration.getLanguageLevel().useJavaAnnotations());
        RuleAnnotationNormalizer ruleAnnotationNormalizer = new RuleAnnotationNormalizer(annotationNormalizer, packageDescr);
        ruleAnnotationNormalizer.process();
        this.results.addAll(ruleAnnotationNormalizer.getResults());
    }

    protected void normalizeAnnotations(AnnotatedBaseDescr annotationsContainer, TypeResolver typeResolver, boolean isStrict) {
        AnnotationNormalizer annotationNormalizer = AnnotationNormalizer.of(typeResolver, this.configuration.getLanguageLevel().useJavaAnnotations());
        annotationNormalizer.normalize(annotationsContainer);
        this.results.addAll(annotationNormalizer.getResults());
    }

    private Map<String, Object> getBuilderCache() {
        if (this.builderCache == null) {
            this.builderCache = new HashMap<String, Object>();
        }
        return this.builderCache;
    }

    public <T> T getCachedOrCreate(String key, Supplier<T> creator) {
        Map<String, Object> builderCache = this.getBuilderCache();
        Object cachedValue = builderCache.get(key);
        if (cachedValue == null) {
            T newValue = creator.get();
            builderCache.put(key, newValue);
            return newValue;
        }
        return (T)cachedValue;
    }

    public final void buildPackages(Collection<CompositePackageDescr> packages) {
        this.doFirstBuildStep(packages);
        this.doSecondBuildStep(packages);
    }

    protected void doFirstBuildStep(Collection<CompositePackageDescr> packages) {
        this.buildPackagesWithoutRules(packages);
        this.buildRules(packages);
    }

    protected void doSecondBuildStep(Collection<CompositePackageDescr> packages) {
    }

    public void buildPackagesWithoutRules(Collection<CompositePackageDescr> packages) {
        this.initPackageRegistries(packages);
        packages.forEach(packageDescr -> this.normalizeTypeDeclarationAnnotations((PackageDescr)packageDescr, this.getOrCreatePackageRegistry((PackageDescr)packageDescr).getTypeResolver()));
        this.buildTypeDeclarations(packages);
        packages.forEach(packageDescr -> this.processEntryPointDeclarations(this.getPackageRegistry(packageDescr.getNamespace()), (PackageDescr)packageDescr));
        this.buildOtherDeclarations(packages);
        packages.forEach(packageDescr -> this.normalizeRuleAnnotations((PackageDescr)packageDescr, this.getOrCreatePackageRegistry((PackageDescr)packageDescr).getTypeResolver()));
    }

    protected void initPackageRegistries(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            if (StringUtils.isEmpty((CharSequence)packageDescr.getName())) {
                packageDescr.setName(this.getBuilderConfiguration().getDefaultPackageName());
            }
            this.getOrCreatePackageRegistry(packageDescr);
        }
    }

    protected void buildEntryPoints(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.processEntryPointDeclarations(this.getPackageRegistry(packageDescr.getNamespace()), packageDescr);
        }
    }

    protected void buildTypeDeclarations(Collection<CompositePackageDescr> packages) {
        HashMap<String, AbstractClassTypeDeclarationDescr> unprocesseableDescrs = new HashMap<String, AbstractClassTypeDeclarationDescr>();
        ArrayList<TypeDefinition> unresolvedTypes = new ArrayList<TypeDefinition>();
        ArrayList<AbstractClassTypeDeclarationDescr> unsortedDescrs = new ArrayList<AbstractClassTypeDeclarationDescr>();
        for (CompositePackageDescr packageDescr : packages) {
            unsortedDescrs.addAll(packageDescr.getTypeDeclarations());
            unsortedDescrs.addAll(packageDescr.getEnumDeclarations());
        }
        this.getTypeBuilder().processTypeDeclarations(packages, unsortedDescrs, unresolvedTypes, unprocesseableDescrs);
        for (CompositePackageDescr packageDescr : packages) {
            for (ImportDescr importDescr : packageDescr.getImports()) {
                this.getPackageRegistry(packageDescr.getNamespace()).addImport(importDescr);
            }
        }
    }

    protected void buildOtherDeclarations(Collection<CompositePackageDescr> packages) {
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            PackageRegistry pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.processOtherDeclarations(pkgRegistry, packageDescr);
            this.setAssetFilter(null);
        }
    }

    protected void buildRules(Collection<CompositePackageDescr> packages) {
        PackageRegistry pkgRegistry;
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileKnowledgePackages(packageDescr, pkgRegistry);
            this.setAssetFilter(null);
        }
        this.wireAllRules();
        this.processKieBaseTypes();
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileRete(pkgRegistry, packageDescr);
            this.setAssetFilter(null);
        }
    }

    public static interface AssetFilter {
        public Action accept(ResourceChange.Type var1, String var2, String var3);

        public static enum Action {
            DO_NOTHING,
            ADD,
            REMOVE,
            UPDATE;

        }
    }

    public static class ForkJoinPoolHolder {
        public static final ForkJoinPool COMPILER_POOL = new ForkJoinPool();
    }
}

