/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.common;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.TraitHelper;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.traits.core.base.TraitHelperImpl;

public class TraitNamedEntryPoint
extends NamedEntryPoint {
    protected TraitHelper traitHelper;

    public TraitNamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, ReteEvaluator reteEvaluator) {
        this(entryPoint, entryPointNode, reteEvaluator, new ReentrantLock());
    }

    public TraitNamedEntryPoint(EntryPointId entryPoint, EntryPointNode entryPointNode, ReteEvaluator reteEvaluator, ReentrantLock lock) {
        this.entryPoint = entryPoint;
        this.entryPointNode = entryPointNode;
        this.reteEvaluator = reteEvaluator;
        this.ruleBase = this.reteEvaluator.getKnowledgeBase();
        this.lock = lock;
        this.handleFactory = this.reteEvaluator.getFactHandleFactory();
        this.pctxFactory = RuntimeComponentFactory.get().getPropagationContextFactory();
        boolean isEqualityBehaviour = RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals((Object)this.ruleBase.getConfiguration().getAssertBehaviour());
        this.objectStore = new ClassAwareObjectStore(isEqualityBehaviour, (Lock)this.lock);
        this.traitHelper = new TraitHelperImpl((InternalWorkingMemoryActions)reteEvaluator, (InternalWorkingMemoryEntryPoint)this);
    }

    protected void beforeUpdate(InternalFactHandle handle, Object object, Activation activation, Object originalObject, PropagationContext propagationContext) {
        if (handle.isTraitable() && object != originalObject && object instanceof TraitableBean && originalObject instanceof TraitableBean) {
            this.traitHelper.replaceCore(handle, object, originalObject, propagationContext.getModificationMask(), object.getClass(), activation);
        }
    }

    protected void afterRetract(InternalFactHandle handle, RuleImpl rule, TerminalNode terminalNode) {
        if (handle.isTraiting() && handle.getObject() instanceof TraitProxy) {
            ((TraitProxy)handle.getObject()).getObject().removeTrait(((TraitProxy)handle.getObject())._getTypeCode());
        } else if (handle.isTraitable()) {
            this.traitHelper.deleteWMAssertedTraitProxies(handle, rule, terminalNode);
        }
    }

    protected void beforeDestroy(RuleImpl rule, TerminalNode terminalNode, InternalFactHandle handle) {
        if (handle.isTraitable()) {
            this.traitHelper.deleteWMAssertedTraitProxies(handle, rule, terminalNode);
        }
    }

    public TraitHelper getTraitHelper() {
        return this.traitHelper;
    }
}

