/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.dataproviders;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.dataproviders.ArrayIterator;
import org.drools.mvel.expr.MVELCompilationUnit;
import org.drools.mvel.expr.MVELCompileable;
import org.drools.mvel.expr.MvelEvaluator;
import org.mvel2.integration.VariableResolverFactory;

public class MVELDataProvider
implements DataProvider,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private MvelEvaluator<Object> evaluator;
    private List<MVELDataProvider> clones;

    public MVELDataProvider() {
    }

    public MVELDataProvider(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MVELDataProvider)) {
            return false;
        }
        return this.unit.equals(((MVELDataProvider)obj).unit);
    }

    public int hashCode() {
        return this.unit.hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
        this.clones = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
        out.writeObject(this.clones);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData));
        if (this.clones != null) {
            for (MVELDataProvider clone : this.clones) {
                clone.evaluator = MvelEvaluator.createMvelEvaluator(clone.unit.getCompiledExpression(runtimeData));
            }
        }
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData, RuleImpl rule) {
        this.evaluator = MvelEvaluator.createMvelEvaluator(this.unit.getCompiledExpression(runtimeData, (Object)rule.toRuleNameAndPathString()));
    }

    public Declaration[] getRequiredDeclarations() {
        return this.unit.getPreviousDeclarations();
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        this.unit.replaceDeclaration(declaration, resolved);
    }

    public Object createContext() {
        return null;
    }

    public Iterator getResults(Tuple tuple, ReteEvaluator reteEvaluator, PropagationContext ctx, Object executionContext) {
        return this.asIterator(this.evaluate(tuple, reteEvaluator));
    }

    protected Object evaluate(Tuple tuple, ReteEvaluator reteEvaluator) {
        VariableResolverFactory factory = this.unit.getFactory(null, null, null, null, tuple, null, reteEvaluator, reteEvaluator.getGlobalResolver());
        return this.evaluator.evaluate(factory);
    }

    protected Iterator asIterator(Object result) {
        if (result == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (result instanceof Iterable) {
            return ((Iterable)result).iterator();
        }
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result.getClass().isArray()) {
            return new ArrayIterator(result);
        }
        return Collections.singletonList(result).iterator();
    }

    public DataProvider clone() {
        MVELDataProvider clone = new MVELDataProvider(this.unit.clone(), this.id);
        clone.evaluator = this.evaluator;
        if (this.clones == null) {
            this.clones = new ArrayList<MVELDataProvider>();
        }
        this.clones.add(clone);
        return clone;
    }

    public boolean isReactive() {
        return false;
    }
}

