/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.Arrays;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.builder.impl.processors.AccumulateFunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.AnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.EntryPointDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.GlobalCompilationPhase;
import org.drools.compiler.builder.impl.processors.ImportCompilationPhase;
import org.drools.compiler.builder.impl.processors.RuleAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.TypeDeclarationAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.TypeDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.WindowDeclarationCompilationPhase;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;

public final class PackageCompilationPhase
extends AbstractPackageCompilationPhase {
    private final KnowledgeBuilderImpl knowledgeBuilder;
    private final InternalKnowledgeBase kBase;
    private final KnowledgeBuilderConfigurationImpl configuration;
    private final TypeDeclarationBuilder typeBuilder;
    private final KnowledgeBuilderImpl.AssetFilter filterCondition;

    public PackageCompilationPhase(KnowledgeBuilderImpl knowledgeBuilder, InternalKnowledgeBase kBase, KnowledgeBuilderConfigurationImpl configuration, TypeDeclarationBuilder typeBuilder, KnowledgeBuilderImpl.AssetFilter filterCondition, PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        super(pkgRegistry, packageDescr);
        this.knowledgeBuilder = knowledgeBuilder;
        this.kBase = kBase;
        this.configuration = configuration;
        this.typeBuilder = typeBuilder;
        this.filterCondition = filterCondition;
    }

    @Override
    public void process() {
        AnnotationNormalizer annotationNormalizer = AnnotationNormalizer.of(this.pkgRegistry.getTypeResolver(), this.configuration.getLanguageLevel().useJavaAnnotations());
        List<CompilationPhase> phases = Arrays.asList(new ImportCompilationPhase(this.pkgRegistry, this.packageDescr), new TypeDeclarationAnnotationNormalizer(annotationNormalizer, this.packageDescr), new EntryPointDeclarationCompilationPhase(this.pkgRegistry, this.packageDescr), new AccumulateFunctionCompilationPhase(this.pkgRegistry, this.packageDescr), new TypeDeclarationCompilationPhase(this.packageDescr, this.typeBuilder, this.pkgRegistry), new WindowDeclarationCompilationPhase(this.pkgRegistry, this.packageDescr, this.knowledgeBuilder), new FunctionCompilationPhase(this.pkgRegistry, this.packageDescr, this.configuration), new GlobalCompilationPhase(this.pkgRegistry, this.packageDescr, this.kBase, this.knowledgeBuilder, this.filterCondition), new RuleAnnotationNormalizer(annotationNormalizer, this.packageDescr));
        phases.forEach(CompilationPhase::process);
        phases.forEach(p -> this.results.addAll(p.getResults()));
    }
}

