/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.util.PortablePath;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaCompilerSettings;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.KieMemoryCompilerException;
import org.kie.memorycompiler.resources.MemoryResourceReader;
import org.kie.memorycompiler.resources.MemoryResourceStore;

public class KieMemoryCompiler {
    private KieMemoryCompiler() {
    }

    public static Map<String, Class<?>> compile(Map<String, String> classNameSourceMap, ClassLoader classLoader) {
        return KieMemoryCompiler.compile(classNameSourceMap, classLoader, null);
    }

    public static Map<String, Class<?>> compile(Map<String, String> classNameSourceMap, ClassLoader classLoader, JavaCompilerSettings compilerSettings) {
        Map<String, byte[]> byteCode = KieMemoryCompiler.compileNoLoad(classNameSourceMap, classLoader, compilerSettings);
        MemoryCompilerClassLoader kieMemoryCompilerClassLoader = new MemoryCompilerClassLoader(classLoader);
        HashMap toReturn = new HashMap();
        for (Map.Entry<String, byte[]> entry : byteCode.entrySet()) {
            kieMemoryCompilerClassLoader.addCode(entry.getKey(), entry.getValue());
            try {
                toReturn.put(entry.getKey(), kieMemoryCompilerClassLoader.loadClass(entry.getKey()));
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), e);
            }
        }
        return toReturn;
    }

    public static Map<String, byte[]> compileNoLoad(Map<String, String> classNameSourceMap, ClassLoader classLoader) {
        return KieMemoryCompiler.compileNoLoad(classNameSourceMap, classLoader, null, JavaConfiguration.CompilerType.NATIVE);
    }

    public static Map<String, byte[]> compileNoLoad(Map<String, String> classNameSourceMap, ClassLoader classLoader, JavaConfiguration.CompilerType compilerType) {
        return KieMemoryCompiler.compileNoLoad(classNameSourceMap, classLoader, null, compilerType);
    }

    public static Map<String, byte[]> compileNoLoad(Map<String, String> classNameSourceMap, ClassLoader classLoader, JavaCompilerSettings compilerSettings) {
        return KieMemoryCompiler.compileNoLoad(classNameSourceMap, classLoader, compilerSettings, JavaConfiguration.CompilerType.NATIVE);
    }

    public static Map<String, byte[]> compileNoLoad(Map<String, String> classNameSourceMap, ClassLoader classLoader, JavaCompilerSettings compilerSettings, JavaConfiguration.CompilerType compilerType) {
        CompilationResult res;
        MemoryResourceReader reader = new MemoryResourceReader();
        MemoryResourceStore store = new MemoryResourceStore();
        String[] classNames = new String[classNameSourceMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : classNameSourceMap.entrySet()) {
            classNames[i] = KieMemoryCompiler.toJavaSource(entry.getKey());
            reader.add(classNames[i], entry.getValue().getBytes());
            ++i;
        }
        JavaConfiguration javaConfiguration = new JavaConfiguration();
        javaConfiguration.setCompiler(compilerType);
        javaConfiguration.setJavaLanguageLevel(JavaConfiguration.findJavaVersion());
        JavaCompiler compiler = JavaCompilerFactory.loadCompiler(javaConfiguration);
        CompilationResult compilationResult = res = compilerSettings == null ? compiler.compile(classNames, reader, store, classLoader) : compiler.compile(classNames, reader, store, classLoader, compilerSettings);
        if (res.getErrors().length > 0) {
            throw new KieMemoryCompilerException(Arrays.toString(res.getErrors()));
        }
        HashMap<String, byte[]> toReturn = new HashMap<String, byte[]>();
        for (Map.Entry<PortablePath, byte[]> entry : store.getResources().entrySet()) {
            toReturn.put(KieMemoryCompiler.toClassName(entry.getKey().asString()), entry.getValue());
        }
        return toReturn;
    }

    private static String toJavaSource(String s) {
        return s.replace('.', '/') + ".java";
    }

    private static String toClassName(String s) {
        if (s.endsWith(".class")) {
            s = s.substring(0, s.length() - 6);
        }
        return s.replace('/', '.');
    }

    public static class MemoryCompilerClassLoader
    extends ClassLoader {
        private Map<String, byte[]> customCompiledCode = new HashMap<String, byte[]>();

        public MemoryCompilerClassLoader(ClassLoader parent) {
            super(parent);
        }

        public void addCode(String name, byte[] bytes) {
            this.customCompiledCode.put(name, bytes);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] byteCode = this.customCompiledCode.get(name);
            if (byteCode == null) {
                return super.findClass(name);
            }
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
    }
}

