/*
 * Copyright (c) 2021. Red Hat, Inc. and/or its affiliates.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.core.rule.accessor;

import org.drools.core.base.ValueType;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;

public interface TupleValueExtractor extends Cloneable {

    ValueType getValueType();

    default Object getValue( Tuple tuple ) {
        return getValue( null, tuple );
    }

    Object getValue( ReteEvaluator reteEvaluator, Tuple tuple );

    TupleValueExtractor clone();
}
