/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.kie.api.runtime.rule.Variable;

public interface QueryArgument
extends Externalizable {
    public static final Var VAR = new Var();
    public static final Null NULL = new Null();

    public QueryArgument normalize(ClassLoader var1);

    public Object getValue(ReteEvaluator var1, LeftTuple var2);

    public static Object evaluateDeclaration(ReteEvaluator reteEvaluator, LeftTuple leftTuple, Declaration declaration) {
        Object tupleObject = leftTuple.get(declaration).getObject();
        if (tupleObject instanceof DroolsQuery && declaration.getExtractor().getIndex() >= 0 && ((DroolsQuery)tupleObject).getVariables()[declaration.getExtractor().getIndex()] != null) {
            return Variable.v;
        }
        return declaration.getValue(reteEvaluator, tupleObject);
    }

    public static class Null
    implements QueryArgument {
        @Override
        public Object getValue(ReteEvaluator reteEvaluator, LeftTuple leftTuple) {
            return null;
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    public static class Var
    implements QueryArgument {
        @Override
        public Object getValue(ReteEvaluator reteEvaluator, LeftTuple leftTuple) {
            return Variable.v;
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    public static class Literal
    implements QueryArgument {
        private Object value;

        public Literal() {
        }

        public Literal(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue(ReteEvaluator reteEvaluator, LeftTuple leftTuple) {
            return this.value;
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            try {
                return this.value instanceof Class ? new Literal(classLoader.loadClass(((Class)this.value).getName())) : this;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readObject();
        }
    }

    public static class Declr
    implements QueryArgument {
        private Declaration declaration;

        public Declr() {
        }

        public Declr(Declaration declaration) {
            this.declaration = declaration;
        }

        @Override
        public Object getValue(ReteEvaluator reteEvaluator, LeftTuple leftTuple) {
            return QueryArgument.evaluateDeclaration(reteEvaluator, leftTuple, this.declaration);
        }

        @Override
        public QueryArgument normalize(ClassLoader classLoader) {
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.declaration);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.declaration = (Declaration)in.readObject();
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public Class<?> getArgumentClass() {
            return this.declaration.getDeclarationClass();
        }
    }
}

