/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.lang.reflect.Type;
import java.util.HashSet;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.GlobalError;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.drl.ast.descr.GlobalDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableGlobalCompilationPhase
extends AbstractPackageCompilationPhase {
    protected static final transient Logger logger = LoggerFactory.getLogger(ImmutableGlobalCompilationPhase.class);
    private final GlobalVariableContext globalVariableContext;

    public ImmutableGlobalCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr, GlobalVariableContext globalVariableContext) {
        super(pkgRegistry, packageDescr);
        this.globalVariableContext = globalVariableContext;
    }

    @Override
    public final void process() {
        InternalKnowledgePackage pkg = this.pkgRegistry.getPackage();
        HashSet existingGlobals = new HashSet(pkg.getGlobals().keySet());
        for (GlobalDescr global : this.packageDescr.getGlobals()) {
            String identifier = global.getIdentifier();
            existingGlobals.remove(identifier);
            String className = global.getType();
            try {
                Type globalType = this.pkgRegistry.getTypeResolver().resolveParametrizedType(className);
                if (globalType instanceof Class && ((Class)globalType).isPrimitive()) {
                    this.results.add((KnowledgeBuilderResult)new GlobalError(global, " Primitive types are not allowed in globals : " + className));
                    return;
                }
                this.addGlobal(pkg, identifier, globalType);
            }
            catch (ClassNotFoundException e) {
                this.results.add((KnowledgeBuilderResult)new GlobalError(global, e.getMessage()));
                logger.warn("ClassNotFoundException occured!", (Throwable)e);
            }
        }
        for (String toBeRemoved : existingGlobals) {
            this.removeGlobal(pkg, toBeRemoved);
        }
    }

    protected void addGlobal(InternalKnowledgePackage pkg, String identifier, Type globalType) {
        pkg.addGlobal(identifier, globalType);
        this.globalVariableContext.addGlobal(identifier, globalType);
    }

    protected void removeGlobal(InternalKnowledgePackage pkg, String toBeRemoved) {
        pkg.removeGlobal(toBeRemoved);
    }
}

